/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import com.garmin.fit.DeveloperDataIdMesg;
import com.garmin.fit.DeveloperField;
import com.garmin.fit.DeveloperFieldDefinition;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldBase;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.FieldDefinitionBase;
import com.garmin.fit.FieldDescriptionMesg;
import com.garmin.fit.Fit;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import com.garmin.fit.MesgNum;
import com.garmin.fit.util.DateTimeConverter;
import com.garmin.fit.util.SemicirclesConverter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSVReader {
    private static final Pattern csvPattern = Pattern.compile("\"([^\"]+?)\",?|([^,]+),?|,");
    private static final Pattern doublePattern = Pattern.compile("^([0-9]+)?\\.[0-9]+$");
    private static final Pattern hexPattern = Pattern.compile("^(0[xX]){1}[a-fA-F0-9]{2}$");
    private final Fit.ProtocolVersion protocolVersion;
    private int unknownMesgCount = 0;
    private int unknownFieldCount = 0;
    private int typeCol = -1;
    private int localNumCol = -1;
    private int mesgCol = -1;
    private int fieldCol = -1;
    private int lineNum = 1;
    private LinkedList<FieldDescriptionMesg> fieldDescriptionMesgs = new LinkedList();
    private HashMap<Short, DeveloperDataIdMesg> developerDataIdMesgs = new HashMap();

    public static boolean read(InputStream inputStream, MesgListener mesgListener, MesgDefinitionListener mesgDefinitionListener) {
        return CSVReader.read(inputStream, mesgListener, mesgDefinitionListener, Fit.ProtocolVersion.V1_0);
    }

    public static boolean read(InputStream inputStream, MesgListener mesgListener, MesgDefinitionListener mesgDefinitionListener, Fit.ProtocolVersion protocolVersion) {
        CSVReader cSVReader = new CSVReader(protocolVersion);
        return cSVReader.readCSV(inputStream, mesgListener, mesgDefinitionListener);
    }

    CSVReader() {
        this(Fit.ProtocolVersion.V1_0);
    }

    CSVReader(Fit.ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public boolean readCSV(InputStream inputStream, MesgListener mesgListener, MesgDefinitionListener mesgDefinitionListener) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String string = bufferedReader.readLine();
            string = this.stripUTF8Bom(string);
            ArrayList<String> arrayList = this.readCells(string);
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get(i).equals("Type")) {
                    this.typeCol = i;
                    continue;
                }
                if (arrayList.get(i).equals("Local Number")) {
                    this.localNumCol = i;
                    continue;
                }
                if (arrayList.get(i).equals("Message")) {
                    this.mesgCol = i;
                    continue;
                }
                if (!arrayList.get(i).equals("Field 1")) continue;
                this.fieldCol = i;
                break;
            }
            while ((string = bufferedReader.readLine()) != null) {
                arrayList = this.readCells(string);
                ++this.lineNum;
                if (arrayList.size() <= this.typeCol || arrayList.size() <= this.localNumCol || arrayList.size() <= this.mesgCol) continue;
                if (arrayList.get(this.mesgCol).equalsIgnoreCase("unknown")) {
                    ++this.unknownMesgCount;
                    continue;
                }
                if (!(arrayList.get(this.typeCol).equalsIgnoreCase("Definition") ? !this.readMessageDefinition(arrayList, mesgDefinitionListener) : arrayList.get(this.typeCol).equalsIgnoreCase("Data") && !this.readMessage(arrayList, mesgListener))) continue;
                return false;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (this.unknownMesgCount > 0 || this.unknownFieldCount > 0) {
            System.out.printf("Ignored %d unknown field(s) and %d unknown message(s) during encoding.\n", this.unknownFieldCount, this.unknownMesgCount);
        }
        return true;
    }

    private ArrayList<String> readCells(String string) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return null;
        }
        Matcher matcher = csvPattern.matcher(string);
        while (matcher.find() && (string2 = matcher.group()) != null) {
            if (string2.endsWith(",")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (string2.length() == 0) {
                string2 = null;
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    private ArrayList<String> readValues(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return null;
        }
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '|') {
                arrayList.add(string2);
                string2 = "";
                continue;
            }
            string2 = string2 + string.charAt(i);
        }
        if (string2.length() > 0) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    private String stripUTF8Bom(String string) {
        byte[] byArray = string.getBytes(Charset.forName("UTF-8"));
        if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            byte[] byArray2 = new byte[byArray.length - 3];
            System.arraycopy(byArray, 3, byArray2, 0, byArray2.length);
            try {
                string = new String(byArray2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return string;
    }

    Boolean isDoubleValue(String string) {
        Matcher matcher = doublePattern.matcher(string);
        return matcher.find();
    }

    Boolean isHexValue(String string) {
        Matcher matcher = hexPattern.matcher(string);
        return matcher.find();
    }

    /*
     * WARNING - void declaration
     */
    private boolean readMessage(ArrayList<String> arrayList, MesgListener mesgListener) {
        Object object;
        Object object2;
        Object object3;
        Mesg mesg = Factory.createMesg(arrayList.get(this.mesgCol));
        if (mesg.getNum() == MesgNum.INVALID) {
            System.err.printf("CSVReader.read(): Error on line %d - Unknown message \"%s\".\n", this.lineNum, mesg.getName());
            return false;
        }
        if (this.localNumCol >= 0) {
            mesg.setLocalNum(Integer.valueOf(arrayList.get(this.localNumCol)));
        }
        int n = this.fieldCol;
        while (n + 2 <= arrayList.size()) {
            object3 = arrayList.get(n++);
            ArrayList<String> arrayList2 = this.readValues(arrayList.get(n++));
            object2 = null;
            ++n;
            if (object3 == null) break;
            if (((String)object3).equalsIgnoreCase("unknown")) {
                ++this.unknownFieldCount;
                continue;
            }
            object = Factory.createField(mesg.getName(), (String)object3);
            if (arrayList2 == null) continue;
            if (((Field)object).getNum() == 255) {
                for (FieldDescriptionMesg fieldDescriptionMesg : this.fieldDescriptionMesgs) {
                    if (!fieldDescriptionMesg.getFieldName(0).equals(object3)) continue;
                    if (this.protocolVersion == Fit.ProtocolVersion.V1_0) {
                        throw new RuntimeException("FIT Protocol Error. A developer field was found while using Protocol Version 1.0. To use developer data, specify the -p2 command line option to enable FIT Protocol 2.0.");
                    }
                    DeveloperDataIdMesg developerDataIdMesg = this.developerDataIdMesgs.get(fieldDescriptionMesg.getDeveloperDataIndex());
                    object2 = new DeveloperField(fieldDescriptionMesg, developerDataIdMesg);
                    break;
                }
            } else {
                object2 = object;
            }
            if (object2 == null) {
                System.err.printf("CSVReader.read(): Error on line %d - Unknown field \"%s\" in message \"%s\".\n", this.lineNum, object3, mesg.getName());
                return false;
            }
            for (String string : arrayList2) {
                int n2 = ((FieldBase)object2).getNumValues();
                if (((FieldBase)object2).getType() == 7) {
                    ((FieldBase)object2).setValue(n2, (Object)string, (String)object3);
                    continue;
                }
                try {
                    void var10_20;
                    boolean bl = false;
                    switch (((FieldBase)object2).getType()) {
                        case 0: {
                            if (!Short.valueOf(string).equals(Fit.ENUM_INVALID)) break;
                            bl = true;
                            break;
                        }
                        case 1: {
                            if (!Byte.valueOf(string).equals(Fit.SINT8_INVALID)) break;
                            bl = true;
                            break;
                        }
                        case 2: {
                            if (!Short.valueOf(string).equals(Fit.UINT8_INVALID)) break;
                            bl = true;
                            break;
                        }
                        case 10: {
                            if (!Short.valueOf(string).equals(Fit.UINT8Z_INVALID)) break;
                            bl = true;
                            break;
                        }
                        case 131: {
                            if (!Short.valueOf(string).equals(Fit.SINT16_INVALID)) break;
                            bl = true;
                            break;
                        }
                        case 132: {
                            if (!Integer.valueOf(string).equals(Fit.UINT16_INVALID)) break;
                            bl = true;
                            break;
                        }
                        case 139: {
                            if (!Integer.valueOf(string).equals(Fit.UINT16Z_INVALID)) break;
                            bl = true;
                            break;
                        }
                        case 133: {
                            void var10_15;
                            if (((Field)object).getUnits().equals("semicircles") && this.isDoubleValue(string).booleanValue()) {
                                int n3 = SemicirclesConverter.degreesToSemicircles(Double.parseDouble(string));
                                String string2 = Integer.toString(n3);
                            }
                            if (!Integer.valueOf((String)var10_15).equals(Fit.SINT32_INVALID)) break;
                            bl = true;
                            break;
                        }
                        case 134: {
                            void var10_17;
                            if (((Field)object).getProfileType().name().equalsIgnoreCase("DATE_TIME")) {
                                String string3 = DateTimeConverter.parseDateTime(string);
                            }
                            if (!Long.valueOf((String)var10_17).equals(Fit.UINT32_INVALID)) break;
                            bl = true;
                            break;
                        }
                        case 140: {
                            if (!Long.valueOf(string).equals(Fit.UINT32Z_INVALID)) break;
                            bl = true;
                            break;
                        }
                        case 136: {
                            if (!Float.valueOf(string).equals(Fit.FLOAT32_INVALID)) break;
                            bl = true;
                            break;
                        }
                        case 137: {
                            if (!Double.valueOf(string).equals(Fit.FLOAT64_INVALID)) break;
                            bl = true;
                            break;
                        }
                        case 13: {
                            void var10_19;
                            if (this.isHexValue(string).booleanValue()) {
                                String string4 = Integer.decode(string).toString();
                            }
                            if (!Short.valueOf((String)var10_19).equals(Fit.BYTE_INVALID)) break;
                            bl = true;
                            break;
                        }
                    }
                    Double d = Double.valueOf((String)var10_20);
                    if (bl) {
                        ((FieldBase)object2).setRawValue(n2, d);
                        continue;
                    }
                    ((FieldBase)object2).setValue(n2, (Object)d, (String)object3);
                }
                catch (NumberFormatException numberFormatException) {
                    ((FieldBase)object2).setValue(n2, (Object)Double.valueOf(string), (String)object3);
                }
            }
            if (object2 instanceof Field) {
                mesg.addField((Field)object2);
                continue;
            }
            mesg.addDeveloperField((DeveloperField)object2);
        }
        if (mesg.getNum() == 206) {
            this.fieldDescriptionMesgs.add(new FieldDescriptionMesg(mesg));
        } else if (mesg.getNum() == 207) {
            object3 = new DeveloperDataIdMesg(mesg);
            short s = ((DeveloperDataIdMesg)object3).getDeveloperDataIndex();
            this.developerDataIdMesgs.put(s, (DeveloperDataIdMesg)object3);
            object2 = this.fieldDescriptionMesgs.iterator();
            while (object2.hasNext()) {
                object = (FieldDescriptionMesg)object2.next();
                if (((FieldDescriptionMesg)object).getDeveloperDataIndex() != s) continue;
                object2.remove();
            }
        }
        if (mesgListener != null) {
            mesgListener.onMesg(mesg);
        }
        return true;
    }

    private boolean readMessageDefinition(ArrayList<String> arrayList, MesgDefinitionListener mesgDefinitionListener) {
        int n = this.fieldCol;
        Mesg mesg = Factory.createMesg(arrayList.get(this.mesgCol));
        if (mesg.getNum() == MesgNum.INVALID) {
            System.err.printf("CSVReader.read(): Error on line %d - Unknown message \"%s\".\n", this.lineNum, mesg.getName());
            return false;
        }
        if (this.localNumCol >= 0) {
            mesg.setLocalNum(Integer.valueOf(arrayList.get(this.localNumCol)));
        }
        MesgDefinition mesgDefinition = new MesgDefinition(mesg);
        while (n + 2 <= arrayList.size()) {
            String string = arrayList.get(n++);
            ArrayList<String> arrayList2 = this.readValues(arrayList.get(n++));
            FieldBase fieldBase = null;
            FieldDefinitionBase fieldDefinitionBase = null;
            ++n;
            if (string == null) break;
            if (string.equalsIgnoreCase("unknown")) {
                ++this.unknownFieldCount;
                continue;
            }
            Field field = Factory.createField(mesg.getName(), string);
            if (arrayList2 == null) continue;
            if (field.getNum() == 255) {
                for (FieldDescriptionMesg fieldDescriptionMesg : this.fieldDescriptionMesgs) {
                    if (!fieldDescriptionMesg.getFieldName(0).equals(string)) continue;
                    if (this.protocolVersion == Fit.ProtocolVersion.V1_0) {
                        throw new RuntimeException("FIT Protocol Error. A developer field was found while using Protocol Version 1.0. To use developer data, specify the -p2 command line option to enable FIT Protocol 2.0.");
                    }
                    DeveloperDataIdMesg developerDataIdMesg = this.developerDataIdMesgs.get(fieldDescriptionMesg.getDeveloperDataIndex());
                    fieldBase = new DeveloperField(fieldDescriptionMesg, developerDataIdMesg);
                    fieldDefinitionBase = new DeveloperFieldDefinition(fieldDescriptionMesg, developerDataIdMesg);
                    break;
                }
            } else {
                fieldBase = field;
                fieldDefinitionBase = new FieldDefinition((Field)fieldBase);
            }
            if (fieldBase == null) {
                System.err.printf("CSVReader.read(): Error on line %d - Unknown field \"%s\" in message \"%s\".\n", this.lineNum, string, mesg.getName());
                return false;
            }
            for (String string2 : arrayList2) {
                ((FieldDefinitionBase)fieldDefinitionBase).setSize(Integer.valueOf(string2) * Fit.baseTypeSizes[((FieldBase)fieldBase).getType() & 0x1F]);
            }
            if (fieldBase instanceof Field) {
                mesgDefinition.addField((FieldDefinition)fieldDefinitionBase);
                continue;
            }
            mesgDefinition.addDeveloperField((DeveloperFieldDefinition)fieldDefinitionBase);
        }
        if (mesgDefinitionListener != null) {
            mesgDefinitionListener.onMesgDefinition(mesgDefinition);
        }
        return true;
    }
}

