/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;

public class CSVWriter {
    private final OutputStream outputStream;
    private ByteArrayOutputStream intermediateOutputStream;
    private BufferedWriter intermediateWriter;
    private final ArrayList<String> headers = new ArrayList();
    private final ArrayList<String> values = new ArrayList();
    private int maxNumberValues = 0;

    public CSVWriter(ByteArrayOutputStream byteArrayOutputStream) {
        this.outputStream = byteArrayOutputStream;
    }

    public void close() {
        try {
            if (this.intermediateWriter != null) {
                this.intermediateWriter.close();
                this.intermediateWriter = null;
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.outputStream, StandardCharsets.UTF_8));
                for (String object2 : this.headers) {
                    bufferedWriter.write(object2 + ",");
                }
                bufferedWriter.write("\n");
                byte[] byArray = this.intermediateOutputStream.toByteArray();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), StandardCharsets.UTF_8));
                while (bufferedReader.ready()) {
                    bufferedWriter.write(bufferedReader.readLine() + "\n");
                }
                bufferedReader.close();
                bufferedWriter.close();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void clear() {
        Collections.fill(this.values, "");
    }

    public void set(String string, Object object) {
        if (string == null) {
            string = "null";
        }
        if (object == null) {
            object = "null";
        }
        for (int i = 0; i < this.headers.size(); ++i) {
            if (this.headers.get(i).compareTo(string) != 0) continue;
            this.values.set(i, object.toString());
            return;
        }
        this.headers.add(string);
        this.values.add(object.toString());
    }

    public void writeln() {
        try {
            if (this.intermediateWriter == null) {
                this.intermediateOutputStream = new ByteArrayOutputStream();
                this.intermediateWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)this.intermediateOutputStream, StandardCharsets.UTF_8));
            }
            for (String string : this.values) {
                this.intermediateWriter.write(string + ",");
            }
            if (this.values.size() < this.maxNumberValues) {
                for (int i = 0; i < this.maxNumberValues - this.values.size(); ++i) {
                    this.intermediateWriter.write(",");
                }
            }
            this.intermediateWriter.write("\n");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void setMaxNumberValues(int n) {
        this.maxNumberValues = n;
    }
}

