/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.ActivityType;
import com.garmin.fit.DateTime;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;

public class MonitoringInfoMesg
extends Mesg {
    public static final int TimestampFieldNum = 253;
    public static final int LocalTimestampFieldNum = 0;
    public static final int ActivityTypeFieldNum = 1;
    public static final int CyclesToDistanceFieldNum = 3;
    public static final int CyclesToCaloriesFieldNum = 4;
    public static final int RestingMetabolicRateFieldNum = 5;
    protected static final Mesg monitoringInfoMesg = new Mesg("monitoring_info", 103);

    public MonitoringInfoMesg() {
        super(Factory.createMesg(103));
    }

    public MonitoringInfoMesg(Mesg mesg) {
        super(mesg);
    }

    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    public void setTimestamp(DateTime dateTime) {
        this.setFieldValue(253, 0, (Object)dateTime.getTimestamp(), 65535);
    }

    public Long getLocalTimestamp() {
        return this.getFieldLongValue(0, 0, 65535);
    }

    public void setLocalTimestamp(Long l) {
        this.setFieldValue(0, 0, (Object)l, 65535);
    }

    public ActivityType[] getActivityType() {
        Short[] shortArray = this.getFieldShortValues(1, 65535);
        ActivityType[] activityTypeArray = new ActivityType[shortArray.length];
        for (int i = 0; i < shortArray.length; ++i) {
            activityTypeArray[i] = ActivityType.getByValue(shortArray[i]);
        }
        return activityTypeArray;
    }

    public int getNumActivityType() {
        return this.getNumFieldValues(1, 65535);
    }

    public ActivityType getActivityType(int n) {
        Short s = this.getFieldShortValue(1, n, 65535);
        if (s == null) {
            return null;
        }
        return ActivityType.getByValue(s);
    }

    public void setActivityType(int n, ActivityType activityType) {
        this.setFieldValue(1, n, (Object)activityType.value, 65535);
    }

    public Float[] getCyclesToDistance() {
        return this.getFieldFloatValues(3, 65535);
    }

    public int getNumCyclesToDistance() {
        return this.getNumFieldValues(3, 65535);
    }

    public Float getCyclesToDistance(int n) {
        return this.getFieldFloatValue(3, n, 65535);
    }

    public void setCyclesToDistance(int n, Float f) {
        this.setFieldValue(3, n, (Object)f, 65535);
    }

    public Float[] getCyclesToCalories() {
        return this.getFieldFloatValues(4, 65535);
    }

    public int getNumCyclesToCalories() {
        return this.getNumFieldValues(4, 65535);
    }

    public Float getCyclesToCalories(int n) {
        return this.getFieldFloatValue(4, n, 65535);
    }

    public void setCyclesToCalories(int n, Float f) {
        this.setFieldValue(4, n, (Object)f, 65535);
    }

    public Integer getRestingMetabolicRate() {
        return this.getFieldIntegerValue(5, 0, 65535);
    }

    public void setRestingMetabolicRate(Integer n) {
        this.setFieldValue(5, 0, (Object)n, 65535);
    }

    static {
        monitoringInfoMesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s", false, Profile.Type.DATE_TIME));
        monitoringInfoMesg.addField(new Field("local_timestamp", 0, 134, 1.0, 0.0, "s", false, Profile.Type.LOCAL_DATE_TIME));
        monitoringInfoMesg.addField(new Field("activity_type", 1, 0, 1.0, 0.0, "", false, Profile.Type.ACTIVITY_TYPE));
        monitoringInfoMesg.addField(new Field("cycles_to_distance", 3, 132, 5000.0, 0.0, "m/cycle", false, Profile.Type.UINT16));
        monitoringInfoMesg.addField(new Field("cycles_to_calories", 4, 132, 5000.0, 0.0, "kcal/cycle", false, Profile.Type.UINT16));
        monitoringInfoMesg.addField(new Field("resting_metabolic_rate", 5, 132, 1.0, 0.0, "kcal / day", false, Profile.Type.UINT16));
    }
}

