/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.AntNetwork;
import com.garmin.fit.BodyLocation;
import com.garmin.fit.DateTime;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;
import com.garmin.fit.SourceType;
import com.garmin.fit.SubField;

public class DeviceInfoMesg
extends Mesg {
    public static final int TimestampFieldNum = 253;
    public static final int DeviceIndexFieldNum = 0;
    public static final int DeviceTypeFieldNum = 1;
    public static final int ManufacturerFieldNum = 2;
    public static final int SerialNumberFieldNum = 3;
    public static final int ProductFieldNum = 4;
    public static final int SoftwareVersionFieldNum = 5;
    public static final int HardwareVersionFieldNum = 6;
    public static final int CumOperatingTimeFieldNum = 7;
    public static final int BatteryVoltageFieldNum = 10;
    public static final int BatteryStatusFieldNum = 11;
    public static final int SensorPositionFieldNum = 18;
    public static final int DescriptorFieldNum = 19;
    public static final int AntTransmissionTypeFieldNum = 20;
    public static final int AntDeviceNumberFieldNum = 21;
    public static final int AntNetworkFieldNum = 22;
    public static final int SourceTypeFieldNum = 25;
    public static final int ProductNameFieldNum = 27;
    public static final int BatteryLevelFieldNum = 32;
    protected static final Mesg deviceInfoMesg;

    public DeviceInfoMesg() {
        super(Factory.createMesg(23));
    }

    public DeviceInfoMesg(Mesg mesg) {
        super(mesg);
    }

    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    public void setTimestamp(DateTime dateTime) {
        this.setFieldValue(253, 0, (Object)dateTime.getTimestamp(), 65535);
    }

    public Short getDeviceIndex() {
        return this.getFieldShortValue(0, 0, 65535);
    }

    public void setDeviceIndex(Short s) {
        this.setFieldValue(0, 0, (Object)s, 65535);
    }

    public Short getDeviceType() {
        return this.getFieldShortValue(1, 0, 65535);
    }

    public void setDeviceType(Short s) {
        this.setFieldValue(1, 0, (Object)s, 65535);
    }

    public Short getBleDeviceType() {
        return this.getFieldShortValue(1, 0, 0);
    }

    public void setBleDeviceType(Short s) {
        this.setFieldValue(1, 0, (Object)s, 0);
    }

    public Short getAntplusDeviceType() {
        return this.getFieldShortValue(1, 0, 1);
    }

    public void setAntplusDeviceType(Short s) {
        this.setFieldValue(1, 0, (Object)s, 1);
    }

    public Short getAntDeviceType() {
        return this.getFieldShortValue(1, 0, 2);
    }

    public void setAntDeviceType(Short s) {
        this.setFieldValue(1, 0, (Object)s, 2);
    }

    public Short getLocalDeviceType() {
        return this.getFieldShortValue(1, 0, 3);
    }

    public void setLocalDeviceType(Short s) {
        this.setFieldValue(1, 0, (Object)s, 3);
    }

    public Integer getManufacturer() {
        return this.getFieldIntegerValue(2, 0, 65535);
    }

    public void setManufacturer(Integer n) {
        this.setFieldValue(2, 0, (Object)n, 65535);
    }

    public Long getSerialNumber() {
        return this.getFieldLongValue(3, 0, 65535);
    }

    public void setSerialNumber(Long l) {
        this.setFieldValue(3, 0, (Object)l, 65535);
    }

    public Integer getProduct() {
        return this.getFieldIntegerValue(4, 0, 65535);
    }

    public void setProduct(Integer n) {
        this.setFieldValue(4, 0, (Object)n, 65535);
    }

    public Integer getFaveroProduct() {
        return this.getFieldIntegerValue(4, 0, 0);
    }

    public void setFaveroProduct(Integer n) {
        this.setFieldValue(4, 0, (Object)n, 0);
    }

    public Integer getGarminProduct() {
        return this.getFieldIntegerValue(4, 0, 1);
    }

    public void setGarminProduct(Integer n) {
        this.setFieldValue(4, 0, (Object)n, 1);
    }

    public Float getSoftwareVersion() {
        return this.getFieldFloatValue(5, 0, 65535);
    }

    public void setSoftwareVersion(Float f) {
        this.setFieldValue(5, 0, (Object)f, 65535);
    }

    public Short getHardwareVersion() {
        return this.getFieldShortValue(6, 0, 65535);
    }

    public void setHardwareVersion(Short s) {
        this.setFieldValue(6, 0, (Object)s, 65535);
    }

    public Long getCumOperatingTime() {
        return this.getFieldLongValue(7, 0, 65535);
    }

    public void setCumOperatingTime(Long l) {
        this.setFieldValue(7, 0, (Object)l, 65535);
    }

    public Float getBatteryVoltage() {
        return this.getFieldFloatValue(10, 0, 65535);
    }

    public void setBatteryVoltage(Float f) {
        this.setFieldValue(10, 0, (Object)f, 65535);
    }

    public Short getBatteryStatus() {
        return this.getFieldShortValue(11, 0, 65535);
    }

    public void setBatteryStatus(Short s) {
        this.setFieldValue(11, 0, (Object)s, 65535);
    }

    public BodyLocation getSensorPosition() {
        Short s = this.getFieldShortValue(18, 0, 65535);
        if (s == null) {
            return null;
        }
        return BodyLocation.getByValue(s);
    }

    public void setSensorPosition(BodyLocation bodyLocation) {
        this.setFieldValue(18, 0, (Object)bodyLocation.value, 65535);
    }

    public String getDescriptor() {
        return this.getFieldStringValue(19, 0, 65535);
    }

    public void setDescriptor(String string) {
        this.setFieldValue(19, 0, (Object)string, 65535);
    }

    public Short getAntTransmissionType() {
        return this.getFieldShortValue(20, 0, 65535);
    }

    public void setAntTransmissionType(Short s) {
        this.setFieldValue(20, 0, (Object)s, 65535);
    }

    public Integer getAntDeviceNumber() {
        return this.getFieldIntegerValue(21, 0, 65535);
    }

    public void setAntDeviceNumber(Integer n) {
        this.setFieldValue(21, 0, (Object)n, 65535);
    }

    public AntNetwork getAntNetwork() {
        Short s = this.getFieldShortValue(22, 0, 65535);
        if (s == null) {
            return null;
        }
        return AntNetwork.getByValue(s);
    }

    public void setAntNetwork(AntNetwork antNetwork) {
        this.setFieldValue(22, 0, (Object)antNetwork.value, 65535);
    }

    public SourceType getSourceType() {
        Short s = this.getFieldShortValue(25, 0, 65535);
        if (s == null) {
            return null;
        }
        return SourceType.getByValue(s);
    }

    public void setSourceType(SourceType sourceType) {
        this.setFieldValue(25, 0, (Object)sourceType.value, 65535);
    }

    public String getProductName() {
        return this.getFieldStringValue(27, 0, 65535);
    }

    public void setProductName(String string) {
        this.setFieldValue(27, 0, (Object)string, 65535);
    }

    public Short getBatteryLevel() {
        return this.getFieldShortValue(32, 0, 65535);
    }

    public void setBatteryLevel(Short s) {
        this.setFieldValue(32, 0, (Object)s, 65535);
    }

    static {
        int n = 0;
        int n2 = 0;
        deviceInfoMesg = new Mesg("device_info", 23);
        deviceInfoMesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s", false, Profile.Type.DATE_TIME));
        ++n;
        deviceInfoMesg.addField(new Field("device_index", 0, 2, 1.0, 0.0, "", false, Profile.Type.DEVICE_INDEX));
        deviceInfoMesg.addField(new Field("device_type", 1, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        n2 = 0;
        DeviceInfoMesg.deviceInfoMesg.fields.get((int)(++n)).subFields.add(new SubField("ble_device_type", 2, 1.0, 0.0, ""));
        DeviceInfoMesg.deviceInfoMesg.fields.get((int)n).subFields.get(n2).addMap(25, 3L);
        DeviceInfoMesg.deviceInfoMesg.fields.get((int)n).subFields.add(new SubField("antplus_device_type", 2, 1.0, 0.0, ""));
        DeviceInfoMesg.deviceInfoMesg.fields.get((int)n).subFields.get(++n2).addMap(25, 1L);
        DeviceInfoMesg.deviceInfoMesg.fields.get((int)n).subFields.add(new SubField("ant_device_type", 2, 1.0, 0.0, ""));
        DeviceInfoMesg.deviceInfoMesg.fields.get((int)n).subFields.get(++n2).addMap(25, 0L);
        DeviceInfoMesg.deviceInfoMesg.fields.get((int)n).subFields.add(new SubField("local_device_type", 2, 1.0, 0.0, ""));
        DeviceInfoMesg.deviceInfoMesg.fields.get((int)n).subFields.get(++n2).addMap(25, 5L);
        ++n2;
        ++n;
        deviceInfoMesg.addField(new Field("manufacturer", 2, 132, 1.0, 0.0, "", false, Profile.Type.MANUFACTURER));
        ++n;
        deviceInfoMesg.addField(new Field("serial_number", 3, 140, 1.0, 0.0, "", false, Profile.Type.UINT32Z));
        deviceInfoMesg.addField(new Field("product", 4, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        n2 = 0;
        DeviceInfoMesg.deviceInfoMesg.fields.get((int)(++n)).subFields.add(new SubField("favero_product", 132, 1.0, 0.0, ""));
        DeviceInfoMesg.deviceInfoMesg.fields.get((int)n).subFields.get(n2).addMap(2, 263L);
        DeviceInfoMesg.deviceInfoMesg.fields.get((int)n).subFields.add(new SubField("garmin_product", 132, 1.0, 0.0, ""));
        DeviceInfoMesg.deviceInfoMesg.fields.get((int)n).subFields.get(++n2).addMap(2, 1L);
        DeviceInfoMesg.deviceInfoMesg.fields.get((int)n).subFields.get(n2).addMap(2, 15L);
        DeviceInfoMesg.deviceInfoMesg.fields.get((int)n).subFields.get(n2).addMap(2, 13L);
        DeviceInfoMesg.deviceInfoMesg.fields.get((int)n).subFields.get(n2).addMap(2, 89L);
        ++n2;
        ++n;
        deviceInfoMesg.addField(new Field("software_version", 5, 132, 100.0, 0.0, "", false, Profile.Type.UINT16));
        ++n;
        deviceInfoMesg.addField(new Field("hardware_version", 6, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        ++n;
        deviceInfoMesg.addField(new Field("cum_operating_time", 7, 134, 1.0, 0.0, "s", false, Profile.Type.UINT32));
        ++n;
        deviceInfoMesg.addField(new Field("battery_voltage", 10, 132, 256.0, 0.0, "V", false, Profile.Type.UINT16));
        ++n;
        deviceInfoMesg.addField(new Field("battery_status", 11, 2, 1.0, 0.0, "", false, Profile.Type.BATTERY_STATUS));
        ++n;
        deviceInfoMesg.addField(new Field("sensor_position", 18, 0, 1.0, 0.0, "", false, Profile.Type.BODY_LOCATION));
        ++n;
        deviceInfoMesg.addField(new Field("descriptor", 19, 7, 1.0, 0.0, "", false, Profile.Type.STRING));
        ++n;
        deviceInfoMesg.addField(new Field("ant_transmission_type", 20, 10, 1.0, 0.0, "", false, Profile.Type.UINT8Z));
        ++n;
        deviceInfoMesg.addField(new Field("ant_device_number", 21, 139, 1.0, 0.0, "", false, Profile.Type.UINT16Z));
        ++n;
        deviceInfoMesg.addField(new Field("ant_network", 22, 0, 1.0, 0.0, "", false, Profile.Type.ANT_NETWORK));
        ++n;
        deviceInfoMesg.addField(new Field("source_type", 25, 0, 1.0, 0.0, "", false, Profile.Type.SOURCE_TYPE));
        ++n;
        deviceInfoMesg.addField(new Field("product_name", 27, 7, 1.0, 0.0, "", false, Profile.Type.STRING));
        ++n;
        deviceInfoMesg.addField(new Field("battery_level", 32, 2, 1.0, 0.0, "%", false, Profile.Type.UINT8));
        ++n;
    }
}

