/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import com.garmin.fit.DeveloperField;
import com.garmin.fit.DeveloperFieldDefinition;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.Fit;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import com.garmin.fit.csv.MesgCSVWriterBase;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;

public class MesgCSVWriter
extends MesgCSVWriterBase
implements MesgListener,
MesgDefinitionListener {
    private int numUnknownMesgs = 0;
    private int numUnknownFields = 0;
    private boolean dataInCsv;

    public MesgCSVWriter(ByteArrayOutputStream byteArrayOutputStream) {
        super(byteArrayOutputStream);
    }

    @Override
    public void close() {
        this.csv.close();
    }

    public int getNumUnknownMesgs() {
        return this.numUnknownMesgs;
    }

    public int getNumUnknownFields() {
        return this.numUnknownFields;
    }

    @Override
    public void onMesgDefinition(MesgDefinition mesgDefinition) {
        ArrayList<FieldDefinition> arrayList = mesgDefinition.getFields();
        Mesg mesg = Factory.createMesg(mesgDefinition.getNum());
        if (this.hideUnknownData && mesg.getName().equals("unknown")) {
            return;
        }
        this.csv.clear();
        this.csv.set("Type", "Definition");
        this.csv.set("Local Number", mesgDefinition.getLocalNum());
        this.csv.set("Message", mesg.getName());
        int n = 0;
        for (FieldDefinition fieldDefinitionBase : arrayList) {
            Field field = Factory.createField(mesgDefinition.getNum(), fieldDefinitionBase.getNum());
            if (this.hideUnknownData && field.getName().equals("unknown")) {
                ++this.numUnknownFields;
                continue;
            }
            this.csv.set("Field " + ++n, field.getName());
            this.csv.set("Value " + n, fieldDefinitionBase.getSize() / Fit.baseTypeSizes[fieldDefinitionBase.getType() & 0x1F]);
            this.csv.set("Units " + n, "");
        }
        for (DeveloperFieldDefinition developerFieldDefinition : mesgDefinition.getDeveloperFields()) {
            if (this.hideUnknownData && !developerFieldDefinition.isDefined()) {
                ++this.numUnknownFields;
                continue;
            }
            ++n;
            if (!developerFieldDefinition.isDefined()) {
                this.csv.set("Field " + n, "undefined-dev-data");
            } else {
                this.csv.set("Field " + n, developerFieldDefinition.getFieldName());
            }
            this.csv.set("Value " + n, developerFieldDefinition.getSize() / Fit.baseTypeSizes[developerFieldDefinition.getType() & 0x1F]);
            this.csv.set("Units " + n, "");
        }
        this.csv.writeln();
        this.dataInCsv = true;
    }

    @Override
    public void onMesg(Mesg mesg) {
        Collection<Field> collection = mesg.getFields();
        if (mesg.getName().equals("unknown") && this.hideUnknownData) {
            ++this.numUnknownMesgs;
            return;
        }
        this.csv.clear();
        this.csv.set("Type", "Data");
        this.csv.set("Local Number", mesg.getLocalNum());
        this.csv.set("Message", mesg.getName());
        if (this.removeExpandedFields) {
            mesg.removeExpandedFields();
        }
        int n = 0;
        for (Field fieldBase : collection) {
            int n2 = mesg.getActiveSubFieldIndex(fieldBase.getNum());
            if (fieldBase.getName().equals("unknown") && this.hideUnknownData) continue;
            this.csv.set("Field " + ++n, fieldBase.getName(n2));
            String string = null;
            if (null == string) {
                string = this.getValueString(fieldBase, n2);
            }
            this.csv.set("Value " + n, string);
            this.csv.set("Units " + n, this.formatUnits(fieldBase.getUnits(), fieldBase.getProfileType().name()));
        }
        for (DeveloperField developerField : mesg.getDeveloperFields()) {
            if (!developerField.isDefined() && this.hideUnknownData) continue;
            this.csv.set("Field " + ++n, developerField.getName());
            String string = this.getValueString(developerField, 65535);
            this.csv.set("Value " + n, string);
            this.csv.set("Units " + n, this.formatUnits(developerField.getUnits()));
        }
        this.csv.writeln();
        this.dataInCsv = true;
    }

    public boolean csvHasData() {
        return this.dataInCsv;
    }
}

