/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.BufferedMesgBroadcaster;
import com.garmin.fit.Decode;
import com.garmin.fit.FitListener;
import com.garmin.fit.FitMessages;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.MesgBroadcastPlugin;
import java.io.InputStream;

public class FitDecoder {
    public FitMessages decode(InputStream inputStream) {
        Decode decode = new Decode();
        FitListener fitListener = new FitListener();
        try {
            decode.read(inputStream, fitListener, null);
        }
        catch (FitRuntimeException fitRuntimeException) {
            if (decode.getInvalidFileDataSize()) {
                decode.nextFile();
                decode.read(inputStream, fitListener, null);
            }
            throw fitRuntimeException;
        }
        return fitListener.getFitMessages();
    }

    public FitMessages decode(InputStream inputStream, MesgBroadcastPlugin mesgBroadcastPlugin) {
        Decode decode = new Decode();
        FitListener fitListener = new FitListener();
        BufferedMesgBroadcaster bufferedMesgBroadcaster = new BufferedMesgBroadcaster(decode);
        bufferedMesgBroadcaster.registerMesgBroadcastPlugin(mesgBroadcastPlugin);
        bufferedMesgBroadcaster.addListener(fitListener);
        try {
            bufferedMesgBroadcaster.run(inputStream);
            bufferedMesgBroadcaster.broadcast();
        }
        catch (FitRuntimeException fitRuntimeException) {
            if (decode.getInvalidFileDataSize()) {
                decode.nextFile();
                bufferedMesgBroadcaster.run(inputStream);
                bufferedMesgBroadcaster.broadcast();
            }
            throw fitRuntimeException;
        }
        return fitListener.getFitMessages();
    }
}

