/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.ActivityType;
import com.garmin.fit.DateTime;
import com.garmin.fit.DiveAlert;
import com.garmin.fit.Event;
import com.garmin.fit.EventType;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.FitnessEquipmentState;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgWithEvent;
import com.garmin.fit.Profile;
import com.garmin.fit.RadarThreatLevelType;
import com.garmin.fit.RiderPositionType;
import com.garmin.fit.SubField;
import com.garmin.fit.TimerTrigger;

public class EventMesg
extends Mesg
implements MesgWithEvent {
    public static final int TimestampFieldNum = 253;
    public static final int EventFieldNum = 0;
    public static final int EventTypeFieldNum = 1;
    public static final int Data16FieldNum = 2;
    public static final int DataFieldNum = 3;
    public static final int EventGroupFieldNum = 4;
    public static final int ScoreFieldNum = 7;
    public static final int OpponentScoreFieldNum = 8;
    public static final int FrontGearNumFieldNum = 9;
    public static final int FrontGearFieldNum = 10;
    public static final int RearGearNumFieldNum = 11;
    public static final int RearGearFieldNum = 12;
    public static final int DeviceIndexFieldNum = 13;
    public static final int ActivityTypeFieldNum = 14;
    public static final int StartTimestampFieldNum = 15;
    public static final int RadarThreatLevelMaxFieldNum = 21;
    public static final int RadarThreatCountFieldNum = 22;
    public static final int RadarThreatAvgApproachSpeedFieldNum = 23;
    public static final int RadarThreatMaxApproachSpeedFieldNum = 24;
    protected static final Mesg eventMesg;

    public EventMesg() {
        super(Factory.createMesg(21));
    }

    public EventMesg(Mesg mesg) {
        super(mesg);
    }

    @Override
    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    @Override
    public void setTimestamp(DateTime dateTime) {
        this.setFieldValue(253, 0, (Object)dateTime.getTimestamp(), 65535);
    }

    @Override
    public Event getEvent() {
        Short s = this.getFieldShortValue(0, 0, 65535);
        if (s == null) {
            return null;
        }
        return Event.getByValue(s);
    }

    @Override
    public void setEvent(Event event) {
        this.setFieldValue(0, 0, (Object)event.value, 65535);
    }

    @Override
    public EventType getEventType() {
        Short s = this.getFieldShortValue(1, 0, 65535);
        if (s == null) {
            return null;
        }
        return EventType.getByValue(s);
    }

    @Override
    public void setEventType(EventType eventType) {
        this.setFieldValue(1, 0, (Object)eventType.value, 65535);
    }

    public Integer getData16() {
        return this.getFieldIntegerValue(2, 0, 65535);
    }

    public void setData16(Integer n) {
        this.setFieldValue(2, 0, (Object)n, 65535);
    }

    public Long getData() {
        return this.getFieldLongValue(3, 0, 65535);
    }

    public void setData(Long l) {
        this.setFieldValue(3, 0, (Object)l, 65535);
    }

    public TimerTrigger getTimerTrigger() {
        Short s = this.getFieldShortValue(3, 0, 0);
        if (s == null) {
            return null;
        }
        return TimerTrigger.getByValue(s);
    }

    public void setTimerTrigger(TimerTrigger timerTrigger) {
        this.setFieldValue(3, 0, (Object)timerTrigger.value, 0);
    }

    public Integer getCoursePointIndex() {
        return this.getFieldIntegerValue(3, 0, 1);
    }

    public void setCoursePointIndex(Integer n) {
        this.setFieldValue(3, 0, (Object)n, 1);
    }

    public Float getBatteryLevel() {
        return this.getFieldFloatValue(3, 0, 2);
    }

    public void setBatteryLevel(Float f) {
        this.setFieldValue(3, 0, (Object)f, 2);
    }

    public Float getVirtualPartnerSpeed() {
        return this.getFieldFloatValue(3, 0, 3);
    }

    public void setVirtualPartnerSpeed(Float f) {
        this.setFieldValue(3, 0, (Object)f, 3);
    }

    public Short getHrHighAlert() {
        return this.getFieldShortValue(3, 0, 4);
    }

    public void setHrHighAlert(Short s) {
        this.setFieldValue(3, 0, (Object)s, 4);
    }

    public Short getHrLowAlert() {
        return this.getFieldShortValue(3, 0, 5);
    }

    public void setHrLowAlert(Short s) {
        this.setFieldValue(3, 0, (Object)s, 5);
    }

    public Float getSpeedHighAlert() {
        return this.getFieldFloatValue(3, 0, 6);
    }

    public void setSpeedHighAlert(Float f) {
        this.setFieldValue(3, 0, (Object)f, 6);
    }

    public Float getSpeedLowAlert() {
        return this.getFieldFloatValue(3, 0, 7);
    }

    public void setSpeedLowAlert(Float f) {
        this.setFieldValue(3, 0, (Object)f, 7);
    }

    public Integer getCadHighAlert() {
        return this.getFieldIntegerValue(3, 0, 8);
    }

    public void setCadHighAlert(Integer n) {
        this.setFieldValue(3, 0, (Object)n, 8);
    }

    public Integer getCadLowAlert() {
        return this.getFieldIntegerValue(3, 0, 9);
    }

    public void setCadLowAlert(Integer n) {
        this.setFieldValue(3, 0, (Object)n, 9);
    }

    public Integer getPowerHighAlert() {
        return this.getFieldIntegerValue(3, 0, 10);
    }

    public void setPowerHighAlert(Integer n) {
        this.setFieldValue(3, 0, (Object)n, 10);
    }

    public Integer getPowerLowAlert() {
        return this.getFieldIntegerValue(3, 0, 11);
    }

    public void setPowerLowAlert(Integer n) {
        this.setFieldValue(3, 0, (Object)n, 11);
    }

    public Float getTimeDurationAlert() {
        return this.getFieldFloatValue(3, 0, 12);
    }

    public void setTimeDurationAlert(Float f) {
        this.setFieldValue(3, 0, (Object)f, 12);
    }

    public Float getDistanceDurationAlert() {
        return this.getFieldFloatValue(3, 0, 13);
    }

    public void setDistanceDurationAlert(Float f) {
        this.setFieldValue(3, 0, (Object)f, 13);
    }

    public Long getCalorieDurationAlert() {
        return this.getFieldLongValue(3, 0, 14);
    }

    public void setCalorieDurationAlert(Long l) {
        this.setFieldValue(3, 0, (Object)l, 14);
    }

    public FitnessEquipmentState getFitnessEquipmentState() {
        Short s = this.getFieldShortValue(3, 0, 15);
        if (s == null) {
            return null;
        }
        return FitnessEquipmentState.getByValue(s);
    }

    public void setFitnessEquipmentState(FitnessEquipmentState fitnessEquipmentState) {
        this.setFieldValue(3, 0, (Object)fitnessEquipmentState.value, 15);
    }

    public Long getSportPoint() {
        return this.getFieldLongValue(3, 0, 16);
    }

    public void setSportPoint(Long l) {
        this.setFieldValue(3, 0, (Object)l, 16);
    }

    public Long getGearChangeData() {
        return this.getFieldLongValue(3, 0, 17);
    }

    public void setGearChangeData(Long l) {
        this.setFieldValue(3, 0, (Object)l, 17);
    }

    public RiderPositionType getRiderPosition() {
        Short s = this.getFieldShortValue(3, 0, 18);
        if (s == null) {
            return null;
        }
        return RiderPositionType.getByValue(s);
    }

    public void setRiderPosition(RiderPositionType riderPositionType) {
        this.setFieldValue(3, 0, (Object)riderPositionType.value, 18);
    }

    public Integer getCommTimeout() {
        return this.getFieldIntegerValue(3, 0, 19);
    }

    public void setCommTimeout(Integer n) {
        this.setFieldValue(3, 0, (Object)n, 19);
    }

    public DiveAlert getDiveAlert() {
        Short s = this.getFieldShortValue(3, 0, 20);
        if (s == null) {
            return null;
        }
        return DiveAlert.getByValue(s);
    }

    public void setDiveAlert(DiveAlert diveAlert) {
        this.setFieldValue(3, 0, (Object)diveAlert.value, 20);
    }

    public Integer getAutoActivityDetectDuration() {
        return this.getFieldIntegerValue(3, 0, 21);
    }

    public void setAutoActivityDetectDuration(Integer n) {
        this.setFieldValue(3, 0, (Object)n, 21);
    }

    public Long getRadarThreatAlert() {
        return this.getFieldLongValue(3, 0, 22);
    }

    public void setRadarThreatAlert(Long l) {
        this.setFieldValue(3, 0, (Object)l, 22);
    }

    @Override
    public Short getEventGroup() {
        return this.getFieldShortValue(4, 0, 65535);
    }

    @Override
    public void setEventGroup(Short s) {
        this.setFieldValue(4, 0, (Object)s, 65535);
    }

    public Integer getScore() {
        return this.getFieldIntegerValue(7, 0, 65535);
    }

    public void setScore(Integer n) {
        this.setFieldValue(7, 0, (Object)n, 65535);
    }

    public Integer getOpponentScore() {
        return this.getFieldIntegerValue(8, 0, 65535);
    }

    public void setOpponentScore(Integer n) {
        this.setFieldValue(8, 0, (Object)n, 65535);
    }

    public Short getFrontGearNum() {
        return this.getFieldShortValue(9, 0, 65535);
    }

    public void setFrontGearNum(Short s) {
        this.setFieldValue(9, 0, (Object)s, 65535);
    }

    public Short getFrontGear() {
        return this.getFieldShortValue(10, 0, 65535);
    }

    public void setFrontGear(Short s) {
        this.setFieldValue(10, 0, (Object)s, 65535);
    }

    public Short getRearGearNum() {
        return this.getFieldShortValue(11, 0, 65535);
    }

    public void setRearGearNum(Short s) {
        this.setFieldValue(11, 0, (Object)s, 65535);
    }

    public Short getRearGear() {
        return this.getFieldShortValue(12, 0, 65535);
    }

    public void setRearGear(Short s) {
        this.setFieldValue(12, 0, (Object)s, 65535);
    }

    public Short getDeviceIndex() {
        return this.getFieldShortValue(13, 0, 65535);
    }

    public void setDeviceIndex(Short s) {
        this.setFieldValue(13, 0, (Object)s, 65535);
    }

    public ActivityType getActivityType() {
        Short s = this.getFieldShortValue(14, 0, 65535);
        if (s == null) {
            return null;
        }
        return ActivityType.getByValue(s);
    }

    public void setActivityType(ActivityType activityType) {
        this.setFieldValue(14, 0, (Object)activityType.value, 65535);
    }

    public DateTime getStartTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(15, 0, 65535));
    }

    public void setStartTimestamp(DateTime dateTime) {
        this.setFieldValue(15, 0, (Object)dateTime.getTimestamp(), 65535);
    }

    public DateTime getAutoActivityDetectStartTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(15, 0, 0));
    }

    public void setAutoActivityDetectStartTimestamp(DateTime dateTime) {
        this.setFieldValue(15, 0, (Object)dateTime.getTimestamp(), 0);
    }

    public RadarThreatLevelType getRadarThreatLevelMax() {
        Short s = this.getFieldShortValue(21, 0, 65535);
        if (s == null) {
            return null;
        }
        return RadarThreatLevelType.getByValue(s);
    }

    public void setRadarThreatLevelMax(RadarThreatLevelType radarThreatLevelType) {
        this.setFieldValue(21, 0, (Object)radarThreatLevelType.value, 65535);
    }

    public Short getRadarThreatCount() {
        return this.getFieldShortValue(22, 0, 65535);
    }

    public void setRadarThreatCount(Short s) {
        this.setFieldValue(22, 0, (Object)s, 65535);
    }

    public Float getRadarThreatAvgApproachSpeed() {
        return this.getFieldFloatValue(23, 0, 65535);
    }

    public void setRadarThreatAvgApproachSpeed(Float f) {
        this.setFieldValue(23, 0, (Object)f, 65535);
    }

    public Float getRadarThreatMaxApproachSpeed() {
        return this.getFieldFloatValue(24, 0, 65535);
    }

    public void setRadarThreatMaxApproachSpeed(Float f) {
        this.setFieldValue(24, 0, (Object)f, 65535);
    }

    static {
        int n = 0;
        int n2 = 0;
        eventMesg = new Mesg("event", 21);
        eventMesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s", false, Profile.Type.DATE_TIME));
        ++n;
        eventMesg.addField(new Field("event", 0, 0, 1.0, 0.0, "", false, Profile.Type.EVENT));
        ++n;
        eventMesg.addField(new Field("event_type", 1, 0, 1.0, 0.0, "", false, Profile.Type.EVENT_TYPE));
        eventMesg.addField(new Field("data16", 2, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        EventMesg.eventMesg.fields.get((int)(++n)).components.add(new FieldComponent(3, false, 16, 1.0, 0.0));
        eventMesg.addField(new Field("data", 3, 134, 1.0, 0.0, "", false, Profile.Type.UINT32));
        n2 = 0;
        EventMesg.eventMesg.fields.get((int)(++n)).subFields.add(new SubField("timer_trigger", 0, 1.0, 0.0, ""));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(n2).addMap(0, 0L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("course_point_index", 132, 1.0, 0.0, ""));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 10L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("battery_level", 132, 1000.0, 0.0, "V"));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 11L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("virtual_partner_speed", 132, 1000.0, 0.0, "m/s"));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 12L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("hr_high_alert", 2, 1.0, 0.0, "bpm"));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 13L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("hr_low_alert", 2, 1.0, 0.0, "bpm"));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 14L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("speed_high_alert", 134, 1000.0, 0.0, "m/s"));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 15L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("speed_low_alert", 134, 1000.0, 0.0, "m/s"));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 16L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("cad_high_alert", 132, 1.0, 0.0, "rpm"));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 17L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("cad_low_alert", 132, 1.0, 0.0, "rpm"));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 18L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("power_high_alert", 132, 1.0, 0.0, "watts"));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 19L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("power_low_alert", 132, 1.0, 0.0, "watts"));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 20L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("time_duration_alert", 134, 1000.0, 0.0, "s"));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 23L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("distance_duration_alert", 134, 100.0, 0.0, "m"));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 24L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("calorie_duration_alert", 134, 1.0, 0.0, "calories"));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 25L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("fitness_equipment_state", 0, 1.0, 0.0, ""));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 27L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("sport_point", 134, 1.0, 0.0, ""));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 33L);
        EventMesg.eventMesg.fields.get((int)n).subFields.get(n2).addComponent(new FieldComponent(7, false, 16, 1.0, 0.0));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(n2).addComponent(new FieldComponent(8, false, 16, 1.0, 0.0));
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("gear_change_data", 134, 1.0, 0.0, ""));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 42L);
        EventMesg.eventMesg.fields.get((int)n).subFields.get(n2).addMap(0, 43L);
        EventMesg.eventMesg.fields.get((int)n).subFields.get(n2).addComponent(new FieldComponent(11, false, 8, 1.0, 0.0));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(n2).addComponent(new FieldComponent(12, false, 8, 1.0, 0.0));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(n2).addComponent(new FieldComponent(9, false, 8, 1.0, 0.0));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(n2).addComponent(new FieldComponent(10, false, 8, 1.0, 0.0));
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("rider_position", 0, 1.0, 0.0, ""));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 44L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("comm_timeout", 132, 1.0, 0.0, ""));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 47L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("dive_alert", 0, 1.0, 0.0, ""));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 56L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("auto_activity_detect_duration", 132, 1.0, 0.0, "min"));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 54L);
        EventMesg.eventMesg.fields.get((int)n).subFields.add(new SubField("radar_threat_alert", 134, 1.0, 0.0, ""));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(++n2).addMap(0, 75L);
        EventMesg.eventMesg.fields.get((int)n).subFields.get(n2).addComponent(new FieldComponent(21, false, 8, 1.0, 0.0));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(n2).addComponent(new FieldComponent(22, false, 8, 1.0, 0.0));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(n2).addComponent(new FieldComponent(23, false, 8, 10.0, 0.0));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(n2).addComponent(new FieldComponent(24, false, 8, 10.0, 0.0));
        ++n2;
        ++n;
        eventMesg.addField(new Field("event_group", 4, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        ++n;
        eventMesg.addField(new Field("score", 7, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        ++n;
        eventMesg.addField(new Field("opponent_score", 8, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        ++n;
        eventMesg.addField(new Field("front_gear_num", 9, 10, 1.0, 0.0, "", false, Profile.Type.UINT8Z));
        ++n;
        eventMesg.addField(new Field("front_gear", 10, 10, 1.0, 0.0, "", false, Profile.Type.UINT8Z));
        ++n;
        eventMesg.addField(new Field("rear_gear_num", 11, 10, 1.0, 0.0, "", false, Profile.Type.UINT8Z));
        ++n;
        eventMesg.addField(new Field("rear_gear", 12, 10, 1.0, 0.0, "", false, Profile.Type.UINT8Z));
        ++n;
        eventMesg.addField(new Field("device_index", 13, 2, 1.0, 0.0, "", false, Profile.Type.DEVICE_INDEX));
        ++n;
        eventMesg.addField(new Field("activity_type", 14, 0, 1.0, 0.0, "", false, Profile.Type.ACTIVITY_TYPE));
        eventMesg.addField(new Field("start_timestamp", 15, 134, 1.0, 0.0, "s", false, Profile.Type.DATE_TIME));
        n2 = 0;
        EventMesg.eventMesg.fields.get((int)(++n)).subFields.add(new SubField("auto_activity_detect_start_timestamp", 134, 1.0, 0.0, "s"));
        EventMesg.eventMesg.fields.get((int)n).subFields.get(n2).addMap(0, 54L);
        ++n2;
        ++n;
        eventMesg.addField(new Field("radar_threat_level_max", 21, 0, 1.0, 0.0, "", false, Profile.Type.RADAR_THREAT_LEVEL_TYPE));
        ++n;
        eventMesg.addField(new Field("radar_threat_count", 22, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        ++n;
        eventMesg.addField(new Field("radar_threat_avg_approach_speed", 23, 2, 10.0, 0.0, "m/s", false, Profile.Type.UINT8));
        ++n;
        eventMesg.addField(new Field("radar_threat_max_approach_speed", 24, 2, 10.0, 0.0, "m/s", false, Profile.Type.UINT8));
        ++n;
    }
}

