/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.plugins;

import com.garmin.fit.ActivityMesg;
import com.garmin.fit.DateTime;
import com.garmin.fit.DeviceInfoMesg;
import com.garmin.fit.File;
import com.garmin.fit.FileIdMesg;
import com.garmin.fit.FitListener;
import com.garmin.fit.FitMessages;
import com.garmin.fit.LapMesg;
import com.garmin.fit.Manufacturer;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgBroadcastPlugin;
import com.garmin.fit.RecordMesg;
import com.garmin.fit.SessionMesg;
import com.garmin.fit.plugins.ActivityFileValidationResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ActivityFileValidationPlugin
implements MesgBroadcastPlugin {
    private static final int MIN_TIMEZONE_OFFSET_IN_SECONDS = -43200;
    private static final int MAX_TIMEZONE_OFFSET_IN_SECONDS = 50400;
    private final FitListener fitListener = new FitListener();
    private final ArrayList<ActivityFileValidationResult> results = new ArrayList();
    private int mesgCount = 0;

    @Override
    public void onIncomingMesg(Mesg mesg) {
        this.fitListener.onMesg(mesg);
        ++this.mesgCount;
    }

    @Override
    public void onBroadcast(List<Mesg> list) {
        FitMessages fitMessages = this.fitListener.getFitMessages();
        this.results.clear();
        this.results.add(this.checkFileIdMesgExists(fitMessages.getFileIdMesgs()));
        if (fitMessages.getFileIdMesgs().size() > 0) {
            this.results.add(this.checkFileIdMesgIsFirst(list));
            this.results.add(this.checkFileIdMesgType(fitMessages.getFileIdMesgs().get(0)));
            this.results.add(this.checkFileIdMesgManufacturerId(fitMessages.getFileIdMesgs().get(0)));
            this.results.add(this.checkFileIdMesgTimeCreated(fitMessages.getFileIdMesgs().get(0)));
        }
        this.results.add(this.checkActivityMesgExists(fitMessages.getActivityMesgs()));
        if (fitMessages.getActivityMesgs().size() > 0) {
            this.results.add(this.checkActivityMesgTimestamp(fitMessages.getActivityMesgs().get(0)));
            this.results.add(this.checkActivityMesgLocalTimeStamp(fitMessages.getActivityMesgs().get(0)));
            this.results.add(this.checkActivityMesgTotalTimerTime(fitMessages.getActivityMesgs().get(0), fitMessages.getSessionMesgs()));
            this.results.add(this.checkActivityMesgSessionCount(fitMessages.getActivityMesgs().get(0), fitMessages.getSessionMesgs().size()));
        }
        this.results.add(this.checkSessionMesgsExists(fitMessages.getSessionMesgs().size()));
        this.results.add(this.checkSessionMesgTimestamp(fitMessages.getSessionMesgs()));
        this.results.add(this.checkSessionMesgStartTime(fitMessages.getSessionMesgs()));
        this.results.add(this.checkSessionMesgTotalTimerTimeAndTotalElapsedTime(fitMessages.getSessionMesgs()));
        this.results.add(this.checkSessionMesgFirstLapIndexAndNumLapsAreSequentialAndAbut(fitMessages.getSessionMesgs(), fitMessages.getLapMesgs()));
        this.results.add(this.checkSessionMesgTotalTimerTime(fitMessages.getSessionMesgs(), fitMessages.getLapMesgs()));
        this.results.add(this.checkSessionMesgTotalElapsedTime(fitMessages.getSessionMesgs(), fitMessages.getLapMesgs()));
        this.results.add(this.checkSessionMesgSport(fitMessages.getSessionMesgs()));
        this.results.add(this.checkSessionMesgSubSport(fitMessages.getSessionMesgs()));
        this.results.add(this.checkSessionMesgsAreSequentialAndAbut(fitMessages.getSessionMesgs()));
        this.results.add(this.checkSessionMesgValidMesgIndexes(fitMessages.getSessionMesgs()));
        this.results.add(this.checkLapMesgsExists(fitMessages.getLapMesgs().size()));
        this.results.add(this.checkLapMesgValidMesgIndexes(fitMessages.getLapMesgs()));
        this.results.add(this.checkLapMesgValidStartTimeAndTimeStamp(fitMessages.getSessionMesgs(), fitMessages.getLapMesgs()));
        this.results.add(this.checkLapMesgsAreSequentialAndAbut(fitMessages.getLapMesgs()));
        this.results.add(this.checkRecordMesgTimestampsAgainstSessionMesgTimes(fitMessages.getSessionMesgs(), fitMessages.getRecordMesgs()));
        this.results.add(this.checkRecordMesgsAreChronological(fitMessages.getRecordMesgs()));
        this.results.add(this.checkDeviceInfoMesgValidTimestamp(fitMessages.getDeviceInfoMesgs()));
        this.results.add(this.checkDeviceInfoMesgValidDeviceIndex(fitMessages.getDeviceInfoMesgs()));
        this.results.add(this.checkDeviceInfoMesgValidManufacturerIdExists(fitMessages.getDeviceInfoMesgs()));
    }

    public void repeatValidation() {
        this.onBroadcast(new ArrayList<Mesg>());
    }

    public int getMesgCount() {
        return this.mesgCount;
    }

    public List<ActivityFileValidationResult> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    ActivityFileValidationResult checkFileIdMesgExists(List<FileIdMesg> list) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("FileId Message Exists", ActivityFileValidationResult.Level.REQUIRED);
        if (list.size() > 0) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        } else {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
        }
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkFileIdMesgIsFirst(List<Mesg> list) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("FileId Message Is First", ActivityFileValidationResult.Level.REQUIRED);
        for (Mesg mesg : list) {
            if (mesg.getName().equals("pad")) continue;
            if (mesg.getName().equals("file_id")) {
                activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
                break;
            }
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            break;
        }
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkFileIdMesgType(FileIdMesg fileIdMesg) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("FileId Message Type Is Activity", ActivityFileValidationResult.Level.REQUIRED);
        if (fileIdMesg.getType() == File.ACTIVITY) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        } else {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("Expected Type: Activity, actual Type: " + (Object)((Object)fileIdMesg.getType()) + ".");
        }
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkFileIdMesgManufacturerId(FileIdMesg fileIdMesg) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("FileId Message Manufacturer Id Exists", ActivityFileValidationResult.Level.REQUIRED);
        if (fileIdMesg.getManufacturer() == null) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("Manufacturer Id is null.");
            return activityFileValidationResult;
        }
        if (Manufacturer.getStringFromValue(fileIdMesg.getManufacturer()).equals("")) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.WARNING);
            activityFileValidationResult.setDescription("Unknown Manufacturer Id " + fileIdMesg.getManufacturer() + ".");
            return activityFileValidationResult;
        }
        activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkFileIdMesgTimeCreated(FileIdMesg fileIdMesg) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("FileId Message Time Created Exists", ActivityFileValidationResult.Level.REQUIRED);
        if (fileIdMesg.getTimeCreated() == null) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("Time Created is null.");
        } else {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        }
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkActivityMesgExists(List<ActivityMesg> list) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("Activity Message Exists", ActivityFileValidationResult.Level.REQUIRED);
        if (list.size() > 0) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        } else {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
        }
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkActivityMesgTimestamp(ActivityMesg activityMesg) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("Activity Message Timestamp Exists", ActivityFileValidationResult.Level.REQUIRED);
        if (activityMesg.getTimestamp() == null) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("Timestamp is null.");
        } else {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        }
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkActivityMesgLocalTimeStamp(ActivityMesg activityMesg) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("Activity Message Local Timestamp is Valid", ActivityFileValidationResult.Level.REQUIRED);
        if (activityMesg.getLocalTimestamp() == null) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("Local Timestamp is null.");
            return activityFileValidationResult;
        }
        Long l = activityMesg.getLocalTimestamp();
        Long l2 = activityMesg.getTimestamp().getTimestamp();
        long l3 = l - l2;
        if (l3 >= -43200L && l3 <= 50400L) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        } else {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("Local Timestamp is not within the tolerated range of [-12,14] hours.");
        }
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkActivityMesgTotalTimerTime(ActivityMesg activityMesg, List<SessionMesg> list) {
        return this.checkValidFieldSums(activityMesg, list, "Activity", "Session", "total_timer_time");
    }

    ActivityFileValidationResult checkActivityMesgSessionCount(ActivityMesg activityMesg, int n) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("Activity Message Session Count Is Equal To Actual Session Count", ActivityFileValidationResult.Level.OPTIONAL);
        if (activityMesg.getNumSessions() == null) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.WARNING);
            activityFileValidationResult.setDescription("Num Sessions is null.");
            return activityFileValidationResult;
        }
        if (activityMesg.getNumSessions() != n) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.WARNING);
            activityFileValidationResult.setDescription("Num Sessions does not match the actual number of Sessions messages found in the file.");
            return activityFileValidationResult;
        }
        activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkSessionMesgsExists(int n) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("Session Message Exists", ActivityFileValidationResult.Level.REQUIRED);
        if (n > 0) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        } else {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
        }
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkSessionMesgTimestamp(List<SessionMesg> list) {
        return this.checkMesgValidTimestamp(list, "Session");
    }

    ActivityFileValidationResult checkSessionMesgStartTime(List<SessionMesg> list) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("Session Message Start Time Is Valid", ActivityFileValidationResult.Level.REQUIRED);
        if (list.size() == 0) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return activityFileValidationResult;
        }
        boolean bl = list.stream().anyMatch(sessionMesg -> sessionMesg.getTimestamp() == null);
        boolean bl2 = list.stream().anyMatch(sessionMesg -> sessionMesg.getStartTime() == null);
        if (bl || bl2) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("One or more Session messages contain a null Start Time and/or a null Timestamp.");
            return activityFileValidationResult;
        }
        for (SessionMesg sessionMesg2 : list) {
            if (!sessionMesg2.getTimestamp().before(sessionMesg2.getStartTime())) continue;
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("A Session message Start Time is greater than its Timestamp.");
            return activityFileValidationResult;
        }
        activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkSessionMesgTotalTimerTimeAndTotalElapsedTime(List<SessionMesg> list) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("Session Message Total Timer Time and Total Elapsed Time are Valid", ActivityFileValidationResult.Level.REQUIRED);
        if (list.size() == 0) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return activityFileValidationResult;
        }
        boolean bl = list.stream().anyMatch(sessionMesg -> sessionMesg.getTotalTimerTime() == null);
        boolean bl2 = list.stream().anyMatch(sessionMesg -> sessionMesg.getTotalElapsedTime() == null);
        if (bl || bl2) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("One or more Session messages contain a null Start Time and/or a null Timestamp.");
            return activityFileValidationResult;
        }
        for (SessionMesg sessionMesg2 : list) {
            if (!(sessionMesg2.getTotalElapsedTime().floatValue() < sessionMesg2.getTotalTimerTime().floatValue())) continue;
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("Session message Total Timer Time " + sessionMesg2.getTotalTimerTime() + " >  Total Elapsed Time" + sessionMesg2.getTotalElapsedTime() + ".");
            return activityFileValidationResult;
        }
        activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkSessionMesgFirstLapIndexAndNumLapsAreSequentialAndAbut(List<SessionMesg> list, List<LapMesg> list2) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("Session Message First Lap Index and Num Laps are Valid", ActivityFileValidationResult.Level.REQUIRED);
        if (list.size() == 0 || list2.size() == 0) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            activityFileValidationResult.setDescription("No Session messages exist and/or no Lap messages exist.");
            return activityFileValidationResult;
        }
        boolean bl = list.stream().anyMatch(sessionMesg -> sessionMesg.getFirstLapIndex() == null);
        boolean bl2 = list.stream().anyMatch(sessionMesg -> sessionMesg.getNumLaps() == null);
        if (bl || bl2) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("One or more Session messages contain a null First Lap Index value and/or null Num Lap value.");
            return activityFileValidationResult;
        }
        int n = 0;
        for (SessionMesg sessionMesg2 : list) {
            if (sessionMesg2.getFirstLapIndex() != n) {
                activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
                activityFileValidationResult.setDescription("One or more Session messages contains an invlaid First Lap Index value.");
                return activityFileValidationResult;
            }
            n += sessionMesg2.getNumLaps().intValue();
        }
        if (n != list2.size()) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("Sum of Session messages Num Laps values is not equal to total number of Lap messages found in the file.");
            return activityFileValidationResult;
        }
        activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkSessionMesgTotalTimerTime(List<SessionMesg> list, List<LapMesg> list2) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("Session Message Total Timer Time Is Equal To Sum of Lap Messages Total Timer Time", ActivityFileValidationResult.Level.REQUIRED);
        if (list.size() == 0 || list2.size() == 0) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            activityFileValidationResult.setDescription("No Session messages exist and/or no Lap messages exist.");
            return activityFileValidationResult;
        }
        boolean bl = list.stream().anyMatch(sessionMesg -> sessionMesg.getTotalTimerTime() == null);
        if (bl) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            return activityFileValidationResult;
        }
        boolean bl2 = list.stream().anyMatch(sessionMesg -> sessionMesg.getFirstLapIndex() == null);
        boolean bl3 = list.stream().anyMatch(sessionMesg -> sessionMesg.getNumLaps() == null);
        if (bl2 || bl3) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("One or more Session messages contain a null First Lap Index value and/or null Num Lap value.");
            return activityFileValidationResult;
        }
        for (SessionMesg sessionMesg2 : list) {
            List list3;
            activityFileValidationResult = this.checkValidFieldSums(sessionMesg2, list3 = list2.stream().skip(sessionMesg2.getFirstLapIndex().intValue()).limit(sessionMesg2.getNumLaps().intValue()).collect(Collectors.toList()), "Session", "Lap", "total_timer_time");
            if (activityFileValidationResult.getStatus() != ActivityFileValidationResult.Status.FAILED) continue;
            return activityFileValidationResult;
        }
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkSessionMesgTotalElapsedTime(List<SessionMesg> list, List<LapMesg> list2) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("Session Message Total Elapsed Time Is Equal To Sum of Lap Messages Total Elapsed Time", ActivityFileValidationResult.Level.REQUIRED);
        if (list.size() == 0 || list2.size() == 0) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            activityFileValidationResult.setDescription("No Session messages exist and/or no Lap messages exist.");
            return activityFileValidationResult;
        }
        boolean bl = list.stream().anyMatch(sessionMesg -> sessionMesg.getTotalElapsedTime() == null);
        if (bl) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            return activityFileValidationResult;
        }
        boolean bl2 = list.stream().anyMatch(sessionMesg -> sessionMesg.getFirstLapIndex() == null);
        boolean bl3 = list.stream().anyMatch(sessionMesg -> sessionMesg.getNumLaps() == null);
        if (bl2 || bl3) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("One or more Session messages contain a null First Lap Index value and/or null Num Lap value.");
            return activityFileValidationResult;
        }
        for (SessionMesg sessionMesg2 : list) {
            List list3;
            activityFileValidationResult = this.checkValidFieldSums(sessionMesg2, list3 = list2.stream().skip(sessionMesg2.getFirstLapIndex().intValue()).limit(sessionMesg2.getNumLaps().intValue()).collect(Collectors.toList()), "Session", "Lap", "total_elapsed_time");
            if (activityFileValidationResult.getStatus() != ActivityFileValidationResult.Status.FAILED) continue;
            return activityFileValidationResult;
        }
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkSessionMesgSport(List<SessionMesg> list) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("Session Message Sport Exists", ActivityFileValidationResult.Level.REQUIRED);
        ActivityFileValidationResult.Status status = this.checkFieldValuesAreValid(list, "sport");
        if (status == ActivityFileValidationResult.Status.FAILED) {
            activityFileValidationResult.setDescription("One or more Session messages contain a null Sport value.");
        }
        activityFileValidationResult.setStatus(status);
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkSessionMesgSubSport(List<SessionMesg> list) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("Session Message Sub Sport Exists", ActivityFileValidationResult.Level.OPTIONAL);
        ActivityFileValidationResult.Status status = this.checkSubSportValuesAreValid(list);
        if (status == ActivityFileValidationResult.Status.WARNING) {
            activityFileValidationResult.setDescription("One or more Session messages contain a null Sub Sport value. Set Sub Sport value to 'generic' if unknown.");
        }
        activityFileValidationResult.setStatus(status);
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkSessionMesgsAreSequentialAndAbut(List<SessionMesg> list) {
        return this.checkMesgsAreSequentialAndAbut(list, "Session");
    }

    ActivityFileValidationResult checkSessionMesgValidMesgIndexes(List<SessionMesg> list) {
        return this.checkValidMesgIndexes(list, "Session");
    }

    ActivityFileValidationResult checkLapMesgValidMesgIndexes(List<LapMesg> list) {
        return this.checkValidMesgIndexes(list, "Lap");
    }

    ActivityFileValidationResult checkLapMesgsExists(int n) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("Lap Message Exists", ActivityFileValidationResult.Level.REQUIRED);
        if (n > 0) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        } else {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
        }
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkLapMesgValidStartTimeAndTimeStamp(List<SessionMesg> list, List<LapMesg> list2) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("Lap Message Start Time and Timestamp are Valid", ActivityFileValidationResult.Level.REQUIRED);
        if (list.size() == 0 || list2.size() == 0) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return activityFileValidationResult;
        }
        boolean bl = list.stream().anyMatch(sessionMesg -> sessionMesg.getStartTime() == null);
        boolean bl2 = list.stream().anyMatch(sessionMesg -> sessionMesg.getTimestamp() == null);
        if (bl || bl2) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("One or more Session messages contain a null Start Time and/or null Timestamp.");
            return activityFileValidationResult;
        }
        boolean bl3 = list.stream().anyMatch(sessionMesg -> sessionMesg.getFirstLapIndex() == null);
        boolean bl4 = list.stream().anyMatch(sessionMesg -> sessionMesg.getNumLaps() == null);
        if (bl3 || bl4) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("One or more Session messages contain a null First Lap Index value and/or a null Num Lap value.");
            return activityFileValidationResult;
        }
        boolean bl5 = list2.stream().anyMatch(lapMesg -> lapMesg.getStartTime() == null);
        boolean bl6 = list2.stream().anyMatch(lapMesg -> lapMesg.getTimestamp() == null);
        if (bl5 || bl6) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("One or more Lap messages contain a null Start Time and/or a null Timestamp.");
            return activityFileValidationResult;
        }
        for (SessionMesg sessionMesg2 : list) {
            List list3 = list2.stream().skip(sessionMesg2.getFirstLapIndex().intValue()).limit(sessionMesg2.getNumLaps().intValue()).collect(Collectors.toList());
            for (LapMesg lapMesg2 : list3) {
                boolean bl7 = lapMesg2.getStartTime().before(sessionMesg2.getStartTime());
                boolean bl8 = lapMesg2.getTimestamp().after(sessionMesg2.getTimestamp());
                if (!bl7 && !bl8) continue;
                activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
                activityFileValidationResult.setDescription("One or more Lap messages contain an incorrect Start Time and/or an incorrect Timestamp relative to the Session message.");
                return activityFileValidationResult;
            }
        }
        activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkLapMesgsAreSequentialAndAbut(List<LapMesg> list) {
        return this.checkMesgsAreSequentialAndAbut(list, "Lap");
    }

    ActivityFileValidationResult checkRecordMesgTimestampsAgainstSessionMesgTimes(List<SessionMesg> list, List<RecordMesg> list2) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("Record Message Timestamps Fall Within Session Message Times", ActivityFileValidationResult.Level.REQUIRED);
        if (list.size() == 0 || list2.size() == 0) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return activityFileValidationResult;
        }
        DateTime dateTime = list.get(0).getStartTime();
        DateTime dateTime2 = list.get(list.size() - 1).getTimestamp();
        if (dateTime == null || dateTime2 == null) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("One or more Session Messages contain a null Start Time and/or a null Timestamp.");
            return activityFileValidationResult;
        }
        DateTime dateTime3 = list2.get(0).getTimestamp();
        DateTime dateTime4 = list2.get(list2.size() - 1).getTimestamp();
        if (dateTime3 == null || dateTime4 == null) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("One or more Record messages contain a null Timestamp.");
            return activityFileValidationResult;
        }
        if (dateTime3.getTimestamp() - dateTime.getTimestamp() < -1L) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("One or more Record message Timestamps is earlier than Session Start Time.");
            return activityFileValidationResult;
        }
        if (dateTime4.getTimestamp() - dateTime2.getTimestamp() > 1L) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("One or more Record message Timestamps is later than Session Timestamp.");
            return activityFileValidationResult;
        }
        activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkRecordMesgsAreChronological(List<RecordMesg> list) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("Record Messages Are in Chronological Ascending Order", ActivityFileValidationResult.Level.REQUIRED);
        if (list.size() == 0) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return activityFileValidationResult;
        }
        boolean bl = list.stream().anyMatch(recordMesg -> recordMesg.getTimestamp() == null);
        if (bl) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("One or more Record messages contain a null Timestamp.");
            return activityFileValidationResult;
        }
        DateTime dateTime = list.get(0).getTimestamp();
        for (RecordMesg recordMesg2 : list) {
            if (dateTime.after(recordMesg2.getTimestamp())) {
                activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
                activityFileValidationResult.setDescription("One or more Record messages are not sequential.");
                return activityFileValidationResult;
            }
            dateTime = recordMesg2.getTimestamp();
        }
        activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkDeviceInfoMesgValidTimestamp(List<DeviceInfoMesg> list) {
        return this.checkMesgValidTimestamp(list, "Device Info");
    }

    ActivityFileValidationResult checkDeviceInfoMesgValidDeviceIndex(List<DeviceInfoMesg> list) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("Device Info Message Device Index is Valid", ActivityFileValidationResult.Level.REQUIRED);
        if (list.size() == 0) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return activityFileValidationResult;
        }
        boolean bl = list.stream().anyMatch(deviceInfoMesg -> deviceInfoMesg.getDeviceIndex() == null);
        if (bl) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("One or more Device Info messages contain a null Device Index value.");
            return activityFileValidationResult;
        }
        boolean bl2 = list.stream().anyMatch(deviceInfoMesg -> deviceInfoMesg.getDeviceIndex().equals((short)0));
        if (!bl2) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("At least one Device Info message Device Index field needs to be set to Creator.");
            return activityFileValidationResult;
        }
        activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkDeviceInfoMesgValidManufacturerIdExists(List<DeviceInfoMesg> list) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult("Device Info Message Manufacturer Id is Valid", ActivityFileValidationResult.Level.OPTIONAL);
        if (list.size() == 0) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return activityFileValidationResult;
        }
        boolean bl = list.stream().anyMatch(deviceInfoMesg -> deviceInfoMesg.getManufacturer() == null);
        if (bl) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.WARNING);
            activityFileValidationResult.setDescription("One or more Device Info messages contain a null Manufacturer Id.");
            return activityFileValidationResult;
        }
        boolean bl2 = list.stream().anyMatch(deviceInfoMesg -> Manufacturer.getStringFromValue(deviceInfoMesg.getManufacturer()).equals(""));
        if (bl2) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.WARNING);
            activityFileValidationResult.setDescription("One or more Device Info messages contain an unknown Manufacturer Id.");
            return activityFileValidationResult;
        }
        activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        return activityFileValidationResult;
    }

    @SafeVarargs
    final boolean isEmpty(List<? extends Mesg> ... listArray) {
        return Arrays.stream(listArray).anyMatch(list -> list.size() == 0);
    }

    ActivityFileValidationResult checkValidMesgIndexes(List<? extends Mesg> list, String string) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult(string + " Message Valid Message Index", ActivityFileValidationResult.Level.REQUIRED);
        if (list.size() == 0) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return activityFileValidationResult;
        }
        for (int i = 0; i < list.size(); ++i) {
            Integer n = list.get(i).getFieldIntegerValue(254, 0, 65535);
            if (n == null) {
                activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
                activityFileValidationResult.setDescription("One or more " + string + " messages contain a null Message Index value.");
                return activityFileValidationResult;
            }
            if (n == i) continue;
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("Message Indexes are not sequential.");
            return activityFileValidationResult;
        }
        activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkMesgValidTimestamp(List<? extends Mesg> list, String string) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult(string + " Message Timestamps are Valid", ActivityFileValidationResult.Level.REQUIRED);
        if (list.size() == 0) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return activityFileValidationResult;
        }
        boolean bl = list.stream().anyMatch(mesg -> mesg.getFieldLongValue("timestamp") == null);
        if (bl) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("One or more " + string + " messages contain a null Timestamp.");
            return activityFileValidationResult;
        }
        activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkValidFieldSums(Mesg mesg2, List<? extends Mesg> list, String string, String string2, String string3) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult(string + " Message " + string3 + " is Equal to the Sum of " + string2 + " Messages " + string3 + " Values", ActivityFileValidationResult.Level.REQUIRED);
        if (list.size() == 0) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            return activityFileValidationResult;
        }
        if (mesg2.getFieldFloatValue(string3) == null) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription(string + " Message contains a null " + string3);
            return activityFileValidationResult;
        }
        boolean bl = list.stream().anyMatch(mesg -> mesg.getFieldFloatValue(string3) == null);
        if (bl) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription(string2 + "Message contains a null " + string3 + " value.");
            return activityFileValidationResult;
        }
        double d = list.stream().mapToDouble(mesg -> mesg.getFieldFloatValue(string3).floatValue()).sum();
        if (Math.abs((double)mesg2.getFieldFloatValue(string3).floatValue() - d) > 1.0) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription(string + " message " + string3 + " does not equal the sum of " + string2 + " messages " + string3 + " values.");
            return activityFileValidationResult;
        }
        activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        return activityFileValidationResult;
    }

    ActivityFileValidationResult checkMesgsAreSequentialAndAbut(List<? extends Mesg> list, String string) {
        ActivityFileValidationResult activityFileValidationResult = new ActivityFileValidationResult(string + " Message Are Sequential and Abut", ActivityFileValidationResult.Level.REQUIRED);
        if (list.size() <= 1) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.SKIPPED);
            activityFileValidationResult.setDescription("Check requires two or more " + string + " messages, found " + list.size() + ".");
            return activityFileValidationResult;
        }
        boolean bl = list.stream().anyMatch(mesg -> mesg.getFieldLongValue("start_time") == null);
        boolean bl2 = list.stream().anyMatch(mesg -> mesg.getFieldLongValue("timestamp") == null);
        if (bl || bl2) {
            activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
            activityFileValidationResult.setDescription("One or more " + string + " messages contain a null Start Time and/or a null Timestamp.");
            return activityFileValidationResult;
        }
        long l = list.get(0).getFieldLongValue("timestamp");
        for (Mesg mesg2 : list.subList(1, list.size())) {
            long l2 = mesg2.getFieldLongValue("start_time");
            if (l2 < l || l2 - l > 1L) {
                activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.FAILED);
                activityFileValidationResult.setDescription(string + " messages are not sequential, or do not abut.");
                return activityFileValidationResult;
            }
            l = mesg2.getFieldLongValue("timestamp");
        }
        activityFileValidationResult.setStatus(ActivityFileValidationResult.Status.PASSED);
        return activityFileValidationResult;
    }

    boolean anyMatchNull(List<? extends Mesg> list, String string) {
        return list.stream().anyMatch(mesg -> mesg.getFieldValue(string) == null);
    }

    boolean allMatchNull(List<? extends Mesg> list, String string) {
        return list.stream().allMatch(mesg -> mesg.getFieldValue(string) == null);
    }

    ActivityFileValidationResult.Status checkFieldValuesAreValid(List<? extends Mesg> list, String string) {
        if (list.size() == 0) {
            return ActivityFileValidationResult.Status.SKIPPED;
        }
        return this.anyMatchNull(list, string) ? ActivityFileValidationResult.Status.FAILED : ActivityFileValidationResult.Status.PASSED;
    }

    ActivityFileValidationResult.Status checkSportValuesAreValid(List<? extends Mesg> list) {
        ActivityFileValidationResult.Status status = this.checkFieldValuesAreValid(list, "sport");
        return status == ActivityFileValidationResult.Status.FAILED ? ActivityFileValidationResult.Status.WARNING : status;
    }

    ActivityFileValidationResult.Status checkSubSportValuesAreValid(List<? extends Mesg> list) {
        ActivityFileValidationResult.Status status = this.checkFieldValuesAreValid(list, "sub_sport");
        return status == ActivityFileValidationResult.Status.FAILED ? ActivityFileValidationResult.Status.WARNING : status;
    }
}

