/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import com.garmin.fit.BufferedMesgListener;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgListener;
import com.garmin.fit.MesgSource;
import java.util.ArrayList;
import java.util.List;

public class CSVDataMesgFieldCounter
implements BufferedMesgListener,
MesgSource {
    private final ArrayList<MesgListener> mesgListeners = new ArrayList();
    private final ArrayList<Mesg> mesgs = new ArrayList();
    private int maxNumFields = 0;

    @Override
    public void onMesg(Mesg mesg) {
        this.mesgs.add(mesg);
        if (mesg.getNumFields() > this.maxNumFields) {
            this.maxNumFields = mesg.getNumFields();
        }
    }

    @Override
    public void flushMesgs() {
        this.flushMesgs(this.mesgs);
    }

    @Override
    public void addListener(MesgListener mesgListener) {
        if (mesgListener != null && !this.mesgListeners.contains(mesgListener)) {
            this.mesgListeners.add(mesgListener);
        }
    }

    private void flushMesg(Mesg mesg) {
        this.mesgListeners.forEach(mesgListener -> mesgListener.onMesg(mesg));
    }

    private void flushMesgs(List<? extends Mesg> list) {
        list.forEach(mesg -> this.flushMesg((Mesg)mesg));
    }

    public int getMaxNumFields() {
        return this.maxNumFields;
    }
}

