/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DeveloperField;
import com.garmin.fit.DeveloperFieldDefinition;
import com.garmin.fit.Field;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.FieldDefinitionBase;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgNum;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class MesgDefinition {
    protected int num;
    protected int localNum;
    protected int arch;
    protected ArrayList<FieldDefinition> fields;
    protected ArrayList<DeveloperFieldDefinition> developerFields;

    protected MesgDefinition() {
        this.num = MesgNum.INVALID;
        this.localNum = 0;
        this.arch = 1;
        this.fields = new ArrayList();
        this.developerFields = new ArrayList();
    }

    public MesgDefinition(Mesg mesg) {
        this.num = mesg.num;
        this.localNum = mesg.localNum;
        this.arch = 1;
        if (this.localNum >= 16) {
            throw new FitRuntimeException("Invalid local message number " + this.localNum + ".  Local message number must be < " + 16 + ".");
        }
        this.fields = new ArrayList();
        this.developerFields = new ArrayList();
        for (Field fieldBase : mesg.fields) {
            this.fields.add(new FieldDefinition(fieldBase));
        }
        for (DeveloperField developerField : mesg.developerFields) {
            this.developerFields.add(new DeveloperFieldDefinition(developerField));
        }
    }

    public int getNum() {
        return this.num;
    }

    public int getLocalNum() {
        return this.localNum;
    }

    public int getArch() {
        return this.arch;
    }

    public ArrayList<FieldDefinition> getFields() {
        return this.fields;
    }

    public FieldDefinition getField(int n) {
        for (FieldDefinition fieldDefinition : this.fields) {
            if (fieldDefinition.num != n) continue;
            return fieldDefinition;
        }
        return null;
    }

    public void addField(FieldDefinition fieldDefinition) {
        this.fields.add(fieldDefinition);
    }

    public void addDeveloperField(DeveloperFieldDefinition developerFieldDefinition) {
        this.developerFields.add(developerFieldDefinition);
    }

    public int getDeveloperFieldTotalSize() {
        int n = 0;
        for (DeveloperFieldDefinition developerFieldDefinition : this.developerFields) {
            n += developerFieldDefinition.getSize();
        }
        return n;
    }

    public void write(OutputStream outputStream) {
        try {
            int n = 0x40 | this.localNum & 0xF;
            if (!this.developerFields.isEmpty()) {
                n |= 0x20;
            }
            outputStream.write(n);
            outputStream.write(0);
            outputStream.write(1);
            outputStream.write(this.num >> 8);
            outputStream.write(this.num);
            outputStream.write(this.fields.size());
            for (FieldDefinition fieldDefinitionBase : this.fields) {
                fieldDefinitionBase.write(outputStream);
            }
            if (!this.developerFields.isEmpty()) {
                outputStream.write(this.developerFields.size());
                for (DeveloperFieldDefinition developerFieldDefinition : this.developerFields) {
                    developerFieldDefinition.write(outputStream);
                }
            }
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
    }

    public boolean supports(Mesg mesg) {
        return this.supports(new MesgDefinition(mesg));
    }

    public boolean supports(MesgDefinition mesgDefinition) {
        FieldDefinitionBase fieldDefinitionBase;
        if (mesgDefinition == null) {
            return false;
        }
        if (this.num != mesgDefinition.num) {
            return false;
        }
        if (this.localNum != mesgDefinition.localNum) {
            return false;
        }
        for (FieldDefinition fieldDefinitionBase2 : mesgDefinition.fields) {
            fieldDefinitionBase = this.getField(fieldDefinitionBase2.num);
            if (fieldDefinitionBase == null) {
                return false;
            }
            if (fieldDefinitionBase2.size <= ((FieldDefinition)fieldDefinitionBase).size) continue;
            return false;
        }
        for (DeveloperFieldDefinition developerFieldDefinition : mesgDefinition.developerFields) {
            fieldDefinitionBase = this.getDeveloperField(developerFieldDefinition.getDeveloperDataIndex(), developerFieldDefinition.getNum());
            if (fieldDefinitionBase == null) {
                return false;
            }
            if (developerFieldDefinition.getSize() <= ((DeveloperFieldDefinition)fieldDefinitionBase).getSize()) continue;
            return false;
        }
        return true;
    }

    private DeveloperFieldDefinition getDeveloperField(short s, int n) {
        for (DeveloperFieldDefinition developerFieldDefinition : this.developerFields) {
            if (developerFieldDefinition.getNum() != n || developerFieldDefinition.getDeveloperDataIndex() != s) continue;
            return developerFieldDefinition;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MesgDefinition)) {
            return false;
        }
        MesgDefinition mesgDefinition = (MesgDefinition)object;
        if (this.num != mesgDefinition.num) {
            return false;
        }
        if (this.localNum != mesgDefinition.localNum) {
            return false;
        }
        if (this.fields.size() != mesgDefinition.fields.size()) {
            return false;
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get(i).equals(mesgDefinition.fields.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + new Integer(this.num).hashCode();
        n = n * 47 + new Integer(this.localNum).hashCode();
        n = n * 19 + this.fields.hashCode();
        return n;
    }

    public Iterable<DeveloperFieldDefinition> getDeveloperFields() {
        return this.developerFields;
    }
}

