/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.FieldDefinitionBase;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.SubField;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class FieldBase {
    protected ArrayList<Object> values = new ArrayList();
    static boolean forceShowInvalids = false;

    protected FieldBase() {
    }

    public FieldBase(FieldBase fieldBase) {
        if (fieldBase != null) {
            for (Object object : fieldBase.values) {
                this.values.add(object);
            }
        }
    }

    public String getName() {
        return this.getNameInternal(null);
    }

    private String getNameInternal(SubField subField) {
        if (subField == null) {
            return this.getFieldName();
        }
        return subField.name;
    }

    public String getName(int n) {
        return this.getNameInternal(this.getSubField(n));
    }

    public String getName(String string) {
        return this.getNameInternal(this.getSubField(string));
    }

    public abstract String getUnits();

    public abstract int getType();

    protected abstract double getOffset();

    protected abstract double getScale();

    protected abstract String getFieldName();

    protected abstract SubField getSubField(String var1);

    protected abstract SubField getSubField(int var1);

    public int getType(int n) {
        return this.getTypeInternal(this.getSubField(n));
    }

    public int getType(String string) {
        return this.getTypeInternal(this.getSubField(string));
    }

    private int getTypeInternal(SubField subField) {
        if (subField == null) {
            return this.getType();
        }
        return subField.type;
    }

    public String getUnits(int n) {
        return this.getUnitsInternal(this.getSubField(n));
    }

    public String getUnits(String string) {
        return this.getUnitsInternal(this.getSubField(string));
    }

    private String getUnitsInternal(SubField subField) {
        if (subField == null) {
            return this.getUnits();
        }
        return subField.units;
    }

    int getSize() {
        int n = 0;
        switch (this.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 10: 
            case 13: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 136: 
            case 137: 
            case 139: 
            case 140: 
            case 142: 
            case 143: 
            case 144: {
                n = this.getNumValues() * Fit.baseTypeSizes[this.getType() & 0x1F];
                break;
            }
            case 7: {
                for (Object object : this.values) {
                    try {
                        n += object.toString().getBytes("UTF-8").length + 1;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
                break;
            }
        }
        return n;
    }

    public void addRawValue(Object object) {
        if (object == null) {
            this.values.add(null);
        } else if (object instanceof Double) {
            switch (this.getType()) {
                case 0: 
                case 2: 
                case 10: 
                case 13: 
                case 131: {
                    this.values.add((short)Math.round(((Number)object).doubleValue()));
                    break;
                }
                case 1: {
                    this.values.add((byte)Math.round(((Number)object).doubleValue()));
                    break;
                }
                case 132: 
                case 133: 
                case 139: {
                    this.values.add((int)Math.round(((Number)object).doubleValue()));
                    break;
                }
                case 134: 
                case 140: {
                    this.values.add(Math.round(((Number)object).doubleValue()));
                    break;
                }
                case 136: {
                    this.values.add(object);
                    break;
                }
                case 137: {
                    this.values.add(object);
                    break;
                }
                case 7: {
                    this.values.add(object.toString());
                    break;
                }
            }
        } else if (object instanceof String && object.equals("")) {
            switch (this.getType()) {
                case 0: {
                    this.values.add(Fit.ENUM_INVALID);
                    break;
                }
                case 1: {
                    this.values.add(Fit.SINT8_INVALID);
                    break;
                }
                case 2: {
                    this.values.add(Fit.UINT8_INVALID);
                    break;
                }
                case 10: {
                    this.values.add(Fit.UINT8Z_INVALID);
                    break;
                }
                case 131: {
                    this.values.add(Fit.SINT16_INVALID);
                    break;
                }
                case 132: {
                    this.values.add(Fit.UINT16_INVALID);
                    break;
                }
                case 139: {
                    this.values.add(Fit.UINT16Z_INVALID);
                    break;
                }
                case 133: {
                    this.values.add(Fit.SINT32_INVALID);
                    break;
                }
                case 134: {
                    this.values.add(Fit.UINT32_INVALID);
                    break;
                }
                case 140: {
                    this.values.add(Fit.UINT32Z_INVALID);
                    break;
                }
                case 7: {
                    this.values.add(object);
                    break;
                }
                case 136: {
                    this.values.add(Fit.FLOAT32_INVALID);
                    break;
                }
                case 137: {
                    this.values.add(Fit.FLOAT64_INVALID);
                    break;
                }
                case 13: {
                    this.values.add(Fit.BYTE_INVALID);
                    break;
                }
            }
        } else {
            this.values.add(object);
        }
    }

    public int getNumValues() {
        return this.values.size();
    }

    protected boolean isSignedInteger() {
        return this.isSignedIntegerInternal(null);
    }

    protected boolean isSignedInteger(int n) {
        return this.isSignedIntegerInternal(this.getSubField(n));
    }

    protected boolean isSignedInteger(String string) {
        return this.isSignedIntegerInternal(this.getSubField(string));
    }

    public boolean isSignedIntegerInternal(SubField subField) {
        int n = subField == null ? this.getType() : subField.getType();
        switch (n) {
            case 1: 
            case 131: 
            case 133: 
            case 142: {
                return true;
            }
        }
        return false;
    }

    public boolean isValid() {
        return this.isValid(0);
    }

    public boolean isValid(int n) {
        int n2 = this.getType(65534);
        if (n >= this.values.size()) {
            return false;
        }
        Object object = this.values.get(n);
        return !(object instanceof Number) || !Fit.baseTypeInvalidMap.get(n2).equals(object);
    }

    public Long getBitsValue(int n, int n2, boolean bl) {
        long l;
        long l2 = 0L;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            Object object;
            if ((object = this.getRawValueInternal(n4++, null)) == null) {
                return null;
            }
            if (!(object instanceof Number)) {
                return null;
            }
            Long l3 = ((Number)object).longValue();
            l3 = l3 >> n;
            int n5 = Fit.baseTypeSizes[this.getType() & 0x1F] * 8 - n;
            n -= Fit.baseTypeSizes[this.getType() & 0x1F] * 8;
            if (n5 <= 0) continue;
            n = 0;
            if (n5 > n2 - n3) {
                n5 = n2 - n3;
            }
            long l4 = (1L << n5) - 1L;
            l2 |= (l3 & l4) << n3;
            n3 += n5;
        }
        if (bl && (l2 & (l = 1L << n2 - 1)) != 0L) {
            l2 = -l + (l2 & l - 1L);
        }
        return l2;
    }

    public Object getRawValue() {
        return this.getRawValueInternal(0, null);
    }

    public Object getRawValue(int n) {
        return this.getRawValueInternal(n, null);
    }

    public Object getRawValue(int n, int n2) {
        return this.getRawValueInternal(n, this.getSubField(n2));
    }

    public Object getRawValue(int n, String string) {
        return this.getRawValueInternal(n, this.getSubField(string));
    }

    protected Object getRawValueInternal(int n, SubField subField) {
        if (n >= this.values.size()) {
            return null;
        }
        Object object = this.values.get(n);
        return object;
    }

    public Object getValue() {
        return this.getValueInternal(0, null);
    }

    public Object getValue(int n) {
        return this.getValueInternal(n, null);
    }

    public Object getValue(int n, int n2) {
        return this.getValueInternal(n, this.getSubField(n2));
    }

    public Object getValue(int n, String string) {
        return this.getValueInternal(n, this.getSubField(string));
    }

    protected Object getValueInternal(int n, SubField subField) {
        double d;
        double d2;
        if (n >= this.values.size()) {
            return null;
        }
        if (subField == null) {
            d2 = this.getScale();
            d = this.getOffset();
        } else {
            d2 = subField.scale;
            d = subField.offset;
        }
        int n2 = this.getTypeInternal(subField);
        Object object = this.values.get(n);
        if (object instanceof Number) {
            if (Fit.baseTypeInvalidMap.get(n2).equals(object)) {
                return Fit.baseTypeInvalidMap.get(n2);
            }
            if (d2 != 1.0 || d != 0.0) {
                return ((Number)object).doubleValue() / d2 - d;
            }
        }
        return object;
    }

    public void setValue(Object object) {
        this.setValueInternal(0, object, null);
    }

    public void setValue(int n, Object object) {
        this.setValueInternal(n, object, null);
    }

    public void setValue(Object object, int n) {
        this.setValueInternal(0, object, this.getSubField(n));
    }

    public void setValue(Object object, String string) {
        this.setValueInternal(0, object, this.getSubField(string));
    }

    public void setValue(int n, Object object, int n2) {
        SubField subField = null;
        if (n2 != 65535 && (subField = this.getSubField(n2)) == null) {
            throw new FitRuntimeException("com.garmin.fit.Field.setValue(): " + n2 + " is not a valid subfield index of " + this.getName() + ".");
        }
        this.setValueInternal(n, object, subField);
    }

    public void setValue(int n, Object object, String string) {
        this.setValueInternal(n, object, this.getSubField(string));
    }

    private Object rangeCorrect(Integer n, Object object) {
        if (Fit.baseTypeMinMap.get(n) == null || Fit.baseTypeMaxMap.get(n) == null) {
            return object;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(Fit.baseTypeMinMap.get(n).toString());
            BigDecimal bigDecimal2 = new BigDecimal(Fit.baseTypeMaxMap.get(n).toString());
            BigDecimal bigDecimal3 = new BigDecimal(object.toString());
            if (bigDecimal3.compareTo(bigDecimal) < 0 || bigDecimal3.compareTo(bigDecimal2) > 0) {
                return Fit.baseTypeInvalidMap.get(n);
            }
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            return Fit.baseTypeInvalidMap.get(n);
        }
    }

    protected void setValueInternal(int n, Object object, SubField subField) {
        double d;
        double d2;
        while (n >= this.getNumValues()) {
            this.addValue(new Object());
        }
        if (subField == null) {
            d2 = this.getScale();
            d = this.getOffset();
        } else {
            d2 = subField.scale;
            d = subField.offset;
        }
        if (object == null) {
            this.values.set(n, null);
        } else if (object instanceof Number && (d2 != 1.0 || d != 0.0)) {
            double d3 = (((Number)object).doubleValue() + d) * d2;
            switch (this.getType()) {
                case 0: 
                case 2: 
                case 10: 
                case 131: {
                    this.values.set(n, this.rangeCorrect(this.getType(), Math.round(d3)));
                    break;
                }
                case 1: {
                    this.values.set(n, this.rangeCorrect(this.getType(), Math.round(d3)));
                    break;
                }
                case 132: 
                case 133: 
                case 139: {
                    this.values.set(n, this.rangeCorrect(this.getType(), Math.round(d3)));
                    break;
                }
                case 134: 
                case 140: 
                case 142: {
                    this.values.set(n, this.rangeCorrect(this.getType(), Math.round(d3)));
                    break;
                }
                case 136: {
                    this.values.set(n, this.rangeCorrect(this.getType(), d3));
                    break;
                }
                case 137: {
                    this.values.set(n, this.rangeCorrect(this.getType(), d3));
                    break;
                }
                case 7: {
                    this.values.set(n, Double.valueOf(d3).toString());
                    break;
                }
                case 143: 
                case 144: {
                    Long l = Math.round(d3);
                    int n2 = Fit.baseTypeSizes[this.getType() & 0x1F];
                    byte[] byArray = new byte[n2];
                    for (int i = 0; i < n2; ++i) {
                        byArray[i] = (byte)(l >>> 8 * i);
                    }
                    this.values.set(n, this.rangeCorrect(this.getType(), new BigInteger(1, byArray)));
                    break;
                }
                case 13: {
                    this.values.set(n, Math.round(d3));
                    break;
                }
            }
        } else {
            this.SetValueUnscaled(n, object);
        }
    }

    private void SetValueUnscaled(int n, Object object) {
        if (object instanceof String && object.equals("")) {
            switch (this.getType()) {
                case 0: 
                case 1: 
                case 2: 
                case 10: 
                case 13: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 136: 
                case 137: 
                case 139: 
                case 140: 
                case 142: 
                case 143: 
                case 144: {
                    this.values.set(n, Fit.baseTypeInvalidMap.get(this.getType()));
                    break;
                }
                case 7: {
                    this.values.set(n, this.rangeCorrect(this.getType(), object));
                    break;
                }
            }
        } else if (object instanceof String) {
            int n2 = ((String)object).getBytes(StandardCharsets.UTF_8).length;
            if (n2 > 254) {
                throw new FitRuntimeException(String.format("Invalid string size. Byte count can not be greater than %d bytes.", 254));
            }
            this.values.set(n, object);
        } else {
            this.values.set(n, this.rangeCorrect(this.getType(), object));
        }
    }

    public void setRawValue(int n, Object object) {
        block13: {
            block14: {
                block12: {
                    while (n >= this.getNumValues()) {
                        this.addValue(new Object());
                    }
                    if (object != null) break block12;
                    this.values.set(n, null);
                    break block13;
                }
                if (!(object instanceof Double)) break block14;
                switch (this.getType()) {
                    case 0: 
                    case 2: 
                    case 10: 
                    case 13: 
                    case 131: {
                        this.values.set(n, (short)Math.round(((Number)object).doubleValue()));
                        break;
                    }
                    case 1: {
                        this.values.set(n, (byte)Math.round(((Number)object).doubleValue()));
                        break;
                    }
                    case 132: 
                    case 133: 
                    case 139: {
                        this.values.set(n, (int)Math.round(((Number)object).doubleValue()));
                        break;
                    }
                    case 134: 
                    case 140: 
                    case 142: {
                        this.values.set(n, Math.round(((Number)object).doubleValue()));
                        break;
                    }
                    case 136: {
                        this.values.set(n, object);
                        break;
                    }
                    case 137: {
                        this.values.set(n, object);
                        break;
                    }
                    case 7: {
                        this.values.set(n, object.toString());
                        break;
                    }
                    case 143: 
                    case 144: {
                        Long l = Math.round(((Number)object).doubleValue());
                        int n2 = Fit.baseTypeSizes[this.getType() & 0x1F];
                        byte[] byArray = new byte[n2];
                        for (int i = 0; i < n2; ++i) {
                            byArray[i] = (byte)(l >>> 8 * i);
                        }
                    }
                }
                break block13;
            }
            this.SetValueUnscaled(n, object);
        }
    }

    public void addValue(Object object) {
        if (object instanceof Number && this.getType() == 7) {
            String string = this.getStringValueInternal(0, null);
            Number number = (Number)object;
            if (string == null) {
                string = "";
            }
            string = string + String.valueOf((char)number.intValue());
            this.setValueInternal(0, string, null);
            return;
        }
        this.values.add(object);
    }

    public Byte[] getByteValues() {
        return this.getByteValues((SubField)null);
    }

    public Byte[] getByteValues(int n) {
        return this.getByteValues(this.getSubField(n));
    }

    public Byte[] getByteValues(String string) {
        return this.getByteValues(this.getSubField(string));
    }

    protected Byte[] getByteValues(SubField subField) {
        Byte[] byteArray = new Byte[this.getNumValues()];
        for (int i = 0; i < this.getNumValues(); ++i) {
            byteArray[i] = this.getByteValueInternal(i, subField);
        }
        return byteArray;
    }

    public Byte getByteValue() {
        return this.getByteValueInternal(0, null);
    }

    public Byte getByteValue(int n) {
        return this.getByteValueInternal(n, null);
    }

    public Byte getByteValue(int n, int n2) {
        return this.getByteValueInternal(n, this.getSubField(n2));
    }

    public Byte getByteValue(int n, String string) {
        return this.getByteValueInternal(n, this.getSubField(string));
    }

    protected Byte getByteValueInternal(int n, SubField subField) {
        Object object = this.getValueInternal(n, subField);
        if (object == null) {
            return null;
        }
        return ((Number)object).byteValue();
    }

    public Short[] getShortValues() {
        return this.getShortValues((SubField)null);
    }

    public Short[] getShortValues(int n) {
        return this.getShortValues(this.getSubField(n));
    }

    public Short[] getShortValues(String string) {
        return this.getShortValues(this.getSubField(string));
    }

    protected Short[] getShortValues(SubField subField) {
        Short[] shortArray = new Short[this.getNumValues()];
        for (int i = 0; i < this.getNumValues(); ++i) {
            shortArray[i] = this.getShortValueInternal(i, subField);
        }
        return shortArray;
    }

    public Short getShortValue() {
        return this.getShortValueInternal(0, null);
    }

    public Short getShortValue(int n) {
        return this.getShortValueInternal(n, null);
    }

    public Short getShortValue(int n, int n2) {
        return this.getShortValueInternal(n, this.getSubField(n2));
    }

    public Short getShortValue(int n, String string) {
        return this.getShortValueInternal(n, this.getSubField(string));
    }

    protected Short getShortValueInternal(int n, SubField subField) {
        Object object = this.getValueInternal(n, subField);
        if (object == null) {
            return null;
        }
        return ((Number)object).shortValue();
    }

    public Integer[] getIntegerValues() {
        return this.getIntegerValues((SubField)null);
    }

    public Integer[] getIntegerValues(int n) {
        return this.getIntegerValues(this.getSubField(n));
    }

    public Integer[] getIntegerValues(String string) {
        return this.getIntegerValues(this.getSubField(string));
    }

    protected Integer[] getIntegerValues(SubField subField) {
        Integer[] integerArray = new Integer[this.getNumValues()];
        for (int i = 0; i < this.getNumValues(); ++i) {
            integerArray[i] = this.getIntegerValueInternal(i, subField);
        }
        return integerArray;
    }

    public Integer getIntegerValue() {
        return this.getIntegerValueInternal(0, null);
    }

    public Integer getIntegerValue(int n) {
        return this.getIntegerValueInternal(n, null);
    }

    public Integer getIntegerValue(int n, int n2) {
        return this.getIntegerValueInternal(n, this.getSubField(n2));
    }

    public Integer getIntegerValue(int n, String string) {
        return this.getIntegerValueInternal(n, this.getSubField(string));
    }

    protected Integer getIntegerValueInternal(int n, SubField subField) {
        Object object = this.getValueInternal(n, subField);
        if (object == null) {
            return null;
        }
        return ((Number)object).intValue();
    }

    public Long[] getLongValues() {
        return this.getLongValues((SubField)null);
    }

    public Long[] getLongValues(int n) {
        return this.getLongValues(this.getSubField(n));
    }

    public Long[] getLongValues(String string) {
        return this.getLongValues(this.getSubField(string));
    }

    protected Long[] getLongValues(SubField subField) {
        Long[] longArray = new Long[this.getNumValues()];
        for (int i = 0; i < this.getNumValues(); ++i) {
            longArray[i] = this.getLongValueInternal(i, subField);
        }
        return longArray;
    }

    public Long getLongValue() {
        return this.getLongValueInternal(0, null);
    }

    public Long getLongValue(int n) {
        return this.getLongValueInternal(n, null);
    }

    public Long getLongValue(int n, int n2) {
        return this.getLongValueInternal(n, this.getSubField(n2));
    }

    public Long getLongValue(int n, String string) {
        return this.getLongValueInternal(n, this.getSubField(string));
    }

    protected Long getLongValueInternal(int n, SubField subField) {
        Object object = this.getValueInternal(n, subField);
        if (object == null) {
            return null;
        }
        return ((Number)object).longValue();
    }

    public Float[] getFloatValues() {
        return this.getFloatValues((SubField)null);
    }

    public Float[] getFloatValues(int n) {
        return this.getFloatValues(this.getSubField(n));
    }

    public Float[] getFloatValues(String string) {
        return this.getFloatValues(this.getSubField(string));
    }

    protected Float[] getFloatValues(SubField subField) {
        Float[] floatArray = new Float[this.getNumValues()];
        for (int i = 0; i < this.getNumValues(); ++i) {
            floatArray[i] = this.getFloatValueInternal(i, subField);
        }
        return floatArray;
    }

    public Float getFloatValue() {
        return this.getFloatValueInternal(0, null);
    }

    public Float getFloatValue(int n) {
        return this.getFloatValueInternal(n, null);
    }

    public Float getFloatValue(int n, int n2) {
        return this.getFloatValueInternal(n, this.getSubField(n2));
    }

    public Float getFloatValue(int n, String string) {
        return this.getFloatValueInternal(n, this.getSubField(string));
    }

    protected Float getFloatValueInternal(int n, SubField subField) {
        Object object = this.getValueInternal(n, subField);
        if (object == null) {
            return null;
        }
        return new Float(((Number)object).doubleValue());
    }

    public Double[] getDoubleValues() {
        return this.getDoubleValues((SubField)null);
    }

    public Double[] getDoubleValues(int n) {
        return this.getDoubleValues(this.getSubField(n));
    }

    public Double[] getDoubleValues(String string) {
        return this.getDoubleValues(this.getSubField(string));
    }

    protected Double[] getDoubleValues(SubField subField) {
        Double[] doubleArray = new Double[this.getNumValues()];
        for (int i = 0; i < this.getNumValues(); ++i) {
            doubleArray[i] = this.getDoubleValueInternal(i, subField);
        }
        return doubleArray;
    }

    public Double getDoubleValue() {
        return this.getDoubleValueInternal(0, null);
    }

    public Double getDoubleValue(int n) {
        return this.getDoubleValueInternal(n, null);
    }

    public Double getDoubleValue(int n, int n2) {
        return this.getDoubleValueInternal(n, this.getSubField(n2));
    }

    public Double getDoubleValue(int n, String string) {
        return this.getDoubleValueInternal(n, this.getSubField(string));
    }

    protected Double getDoubleValueInternal(int n, SubField subField) {
        Object object = this.getValueInternal(n, subField);
        if (object == null) {
            return null;
        }
        return new Double(((Number)object).doubleValue());
    }

    public BigInteger[] getBigIntegerValues() {
        return this.getBigIntegerValues((SubField)null);
    }

    public BigInteger[] getBigIntegerValues(int n) {
        return this.getBigIntegerValues(this.getSubField(n));
    }

    public BigInteger[] getBigIntegerValues(String string) {
        return this.getBigIntegerValues(this.getSubField(string));
    }

    protected BigInteger[] getBigIntegerValues(SubField subField) {
        BigInteger[] bigIntegerArray = new BigInteger[this.getNumValues()];
        for (int i = 0; i < this.getNumValues(); ++i) {
            bigIntegerArray[i] = this.getBigIntegerValueInternal(i, subField);
        }
        return bigIntegerArray;
    }

    public BigInteger getBigIntegerValue() {
        return this.getBigIntegerValueInternal(0, null);
    }

    public BigInteger getBigIntegerValue(int n) {
        return this.getBigIntegerValueInternal(n, null);
    }

    public BigInteger getBigIntegerValue(int n, int n2) {
        return this.getBigIntegerValueInternal(n, this.getSubField(n2));
    }

    public BigInteger getBigIntegerValue(int n, String string) {
        return this.getBigIntegerValueInternal(n, this.getSubField(string));
    }

    protected BigInteger getBigIntegerValueInternal(int n, SubField subField) {
        Object object = this.getValueInternal(n, subField);
        if (object == null) {
            return null;
        }
        return (BigInteger)object;
    }

    public String[] getStringValues() {
        return this.getStringValues((SubField)null);
    }

    public String[] getStringValues(int n) {
        return this.getStringValues(this.getSubField(n));
    }

    public String[] getStringValues(String string) {
        return this.getStringValues(this.getSubField(string));
    }

    protected String[] getStringValues(SubField subField) {
        String[] stringArray = new String[this.getNumValues()];
        for (int i = 0; i < this.getNumValues(); ++i) {
            stringArray[i] = this.getStringValueInternal(i, subField);
        }
        return stringArray;
    }

    public String getStringValue() {
        return this.getStringValueInternal(0, null);
    }

    public String getStringValue(int n) {
        return this.getStringValueInternal(n, null);
    }

    public String getStringValue(int n, int n2) {
        return this.getStringValueInternal(n, this.getSubField(n2));
    }

    public String getStringValue(int n, String string) {
        return this.getStringValueInternal(n, this.getSubField(string));
    }

    protected String getStringValueInternal(int n, SubField subField) {
        Object object = this.getValueInternal(n, subField);
        int n2 = this.getTypeInternal(subField);
        if (object == null) {
            return null;
        }
        if (!forceShowInvalids && Fit.baseTypeInvalidMap.get(n2).equals(object)) {
            return null;
        }
        return object.toString();
    }

    boolean read(InputStream inputStream, int n) {
        block21: {
            try {
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                if (this.getType() == 7) {
                    try {
                        byte[] byArray = new byte[n];
                        inputStream.read(byArray, 0, n);
                        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                        CharsetDecoder charsetDecoder = Charset.forName("UTF-8").newDecoder();
                        charsetDecoder.onMalformedInput(CodingErrorAction.IGNORE);
                        charsetDecoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
                        CharBuffer charBuffer = charsetDecoder.decode(byteBuffer);
                        String[] stringArray = charBuffer.toString().split("\u0000");
                        Arrays.stream(stringArray).forEach(string -> this.values.add(string));
                        break block21;
                    }
                    catch (IOException iOException) {
                        return true;
                    }
                }
                boolean bl = true;
                int n2 = this.getType();
                int n3 = Fit.baseTypeSizes[n2 & 0x1F];
                Object object = Fit.baseTypeInvalidMap.get(n2);
                for (int i = n; i > 0; i -= Fit.baseTypeSizes[this.getType() & 0x1F]) {
                    Number number = null;
                    switch (n2) {
                        case 0: 
                        case 2: 
                        case 10: {
                            number = (short)(dataInputStream.readByte() & 0xFF);
                            break;
                        }
                        case 1: {
                            number = dataInputStream.readByte();
                            break;
                        }
                        case 131: {
                            number = dataInputStream.readShort();
                            break;
                        }
                        case 132: 
                        case 139: {
                            number = dataInputStream.readByte() & 0xFF;
                            number = (Integer)number << 8;
                            number = (Integer)number | dataInputStream.readByte() & 0xFF;
                            break;
                        }
                        case 133: {
                            number = dataInputStream.readInt();
                            break;
                        }
                        case 134: 
                        case 140: 
                        case 142: {
                            number = (long)(dataInputStream.readByte() & 0xFF);
                            for (int j = 1; j < n3; ++j) {
                                number = (Long)number << 8;
                                number = (Long)number | (long)(dataInputStream.readByte() & 0xFF);
                            }
                            break;
                        }
                        case 136: {
                            number = Float.valueOf(dataInputStream.readFloat());
                            break;
                        }
                        case 137: {
                            number = dataInputStream.readDouble();
                            break;
                        }
                        case 13: {
                            number = (short)(dataInputStream.readByte() & 0xFF);
                            break;
                        }
                        case 143: 
                        case 144: {
                            byte[] byArray = new byte[n3];
                            dataInputStream.read(byArray, 0, n3);
                            number = new BigInteger(1, byArray);
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    if (number != null) {
                        this.values.add(number);
                    }
                    if (number.equals(object)) continue;
                    bl = false;
                }
                if (bl && !forceShowInvalids) {
                    this.values.clear();
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    protected void write(OutputStream outputStream, FieldDefinitionBase fieldDefinitionBase) {
        this.write(outputStream);
        for (int i = fieldDefinitionBase.getSize() - this.getSize(); i > 0; i -= Fit.baseTypeSizes[this.getType() & 0x1F]) {
            this.writeValue(outputStream, null);
        }
    }

    protected void write(OutputStream outputStream) {
        for (Object object : this.values) {
            this.writeValue(outputStream, object);
        }
    }

    private void writeValue(OutputStream outputStream, Object object) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            if (object == null) {
                switch (this.getType()) {
                    case 0: {
                        dataOutputStream.writeByte(Fit.ENUM_INVALID.shortValue());
                        break;
                    }
                    case 2: {
                        dataOutputStream.writeByte(Fit.UINT8_INVALID.shortValue());
                        break;
                    }
                    case 10: {
                        dataOutputStream.writeByte(Fit.UINT8Z_INVALID.shortValue());
                        break;
                    }
                    case 1: {
                        dataOutputStream.writeByte(Fit.SINT8_INVALID.byteValue());
                        break;
                    }
                    case 13: {
                        dataOutputStream.writeByte(Fit.BYTE_INVALID.shortValue());
                        break;
                    }
                    case 131: {
                        dataOutputStream.writeShort(Fit.SINT16_INVALID.shortValue());
                        break;
                    }
                    case 132: {
                        dataOutputStream.writeShort(Fit.UINT16_INVALID);
                        break;
                    }
                    case 139: {
                        dataOutputStream.writeShort(Fit.UINT16Z_INVALID);
                        break;
                    }
                    case 133: {
                        dataOutputStream.writeInt(Fit.SINT32_INVALID);
                        break;
                    }
                    case 134: {
                        dataOutputStream.writeInt((int)Fit.UINT32_INVALID.longValue());
                        break;
                    }
                    case 140: {
                        dataOutputStream.writeInt((int)Fit.UINT32Z_INVALID.longValue());
                        break;
                    }
                    case 142: {
                        dataOutputStream.writeLong(Fit.SINT64_INVALID);
                        break;
                    }
                    case 143: {
                        dataOutputStream.writeLong(Fit.UINT64_INVALID.longValue());
                        break;
                    }
                    case 144: {
                        dataOutputStream.writeLong(Fit.UINT64Z_INVALID.longValue());
                        break;
                    }
                    case 7: {
                        dataOutputStream.writeByte(0);
                        break;
                    }
                    case 136: {
                        dataOutputStream.writeFloat(Fit.FLOAT32_INVALID.floatValue());
                        break;
                    }
                    case 137: {
                        dataOutputStream.writeDouble(Fit.FLOAT64_INVALID);
                        break;
                    }
                }
            } else {
                switch (this.getType()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 10: 
                    case 13: {
                        if (object instanceof String) {
                            System.err.printf("Field.write(): Field %s value should not be string value %s\n", this.getFieldName(), object);
                        }
                        dataOutputStream.writeByte((int)Math.round(((Number)object).doubleValue()));
                        break;
                    }
                    case 131: 
                    case 132: 
                    case 139: {
                        dataOutputStream.writeShort((int)Math.round(((Number)object).doubleValue()));
                        break;
                    }
                    case 133: 
                    case 134: 
                    case 140: {
                        dataOutputStream.writeInt((int)Math.round(((Number)object).doubleValue()));
                        break;
                    }
                    case 7: {
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                        outputStreamWriter.write(object.toString());
                        outputStreamWriter.flush();
                        outputStream.write(0);
                        break;
                    }
                    case 136: {
                        dataOutputStream.writeFloat(((Number)object).floatValue());
                        break;
                    }
                    case 137: {
                        dataOutputStream.writeDouble(((Number)object).doubleValue());
                        break;
                    }
                    case 142: 
                    case 143: 
                    case 144: {
                        dataOutputStream.writeLong(((Number)object).longValue());
                        break;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

